/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.artifact;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.AbstractArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataStoreException;
import org.apache.maven.repository.legacy.metadata.ArtifactMetadata;
import org.codehaus.plexus.util.FileUtils;

public class ProjectArtifactMetadata
extends AbstractArtifactMetadata {
    private final File file;

    public ProjectArtifactMetadata(Artifact artifact) {
        this(artifact, null);
    }

    public ProjectArtifactMetadata(Artifact artifact, File file) {
        super(artifact);
        this.file = file;
    }

    public String getRemoteFilename() {
        return this.getFilename();
    }

    public String getLocalFilename(ArtifactRepository repository) {
        return this.getFilename();
    }

    private String getFilename() {
        return this.getArtifactId() + "-" + this.artifact.getVersion() + ".pom";
    }

    public void storeInLocalRepository(ArtifactRepository localRepository, ArtifactRepository remoteRepository) throws RepositoryMetadataStoreException {
        File destination = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata((org.apache.maven.artifact.metadata.ArtifactMetadata)this, remoteRepository));
        try {
            FileUtils.copyFile((File)this.file, (File)destination);
        }
        catch (IOException e) {
            throw new RepositoryMetadataStoreException("Error copying POM to the local repository.", (Exception)e);
        }
    }

    public String toString() {
        return "project information for " + this.artifact.getArtifactId() + " " + this.artifact.getVersion();
    }

    public boolean storedInArtifactVersionDirectory() {
        return true;
    }

    public String getBaseVersion() {
        return this.artifact.getBaseVersion();
    }

    public Object getKey() {
        return "project " + this.artifact.getGroupId() + ":" + this.artifact.getArtifactId();
    }

    public void merge(org.apache.maven.artifact.metadata.ArtifactMetadata metadata) {
        ProjectArtifactMetadata m = (ProjectArtifactMetadata)metadata;
        if (!m.file.equals(this.file)) {
            throw new IllegalStateException("Cannot add two different pieces of metadata for: " + this.getKey());
        }
    }

    public void merge(ArtifactMetadata metadata) {
        this.merge((org.apache.maven.artifact.metadata.ArtifactMetadata)metadata);
    }
}

