/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.legacy.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultRepositoryRequest;
import org.apache.maven.artifact.repository.RepositoryCache;
import org.apache.maven.artifact.repository.RepositoryRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.repository.ArtifactTransferListener;
import org.apache.maven.repository.legacy.metadata.MetadataResolutionRequest;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMetadataResolutionRequest
implements MetadataResolutionRequest {
    private Artifact artifact;
    private boolean resolveManagedVersions;
    private RepositoryRequest repositoryRequest;
    private List<Server> servers;
    private List<Mirror> mirrors;
    private List<Proxy> proxies;

    public DefaultMetadataResolutionRequest() {
        this.repositoryRequest = new DefaultRepositoryRequest();
    }

    public DefaultMetadataResolutionRequest(RepositoryRequest repositoryRequest) {
        this.repositoryRequest = new DefaultRepositoryRequest(repositoryRequest);
    }

    public DefaultMetadataResolutionRequest(ArtifactResolutionRequest resolutionRequest) {
        this.repositoryRequest = new DefaultRepositoryRequest(resolutionRequest);
        this.setServers(resolutionRequest.getServers());
        this.setMirrors(resolutionRequest.getMirrors());
        this.setProxies(resolutionRequest.getProxies());
    }

    @Override
    public Artifact getArtifact() {
        return this.artifact;
    }

    @Override
    public DefaultMetadataResolutionRequest setArtifact(Artifact artifact) {
        this.artifact = artifact;
        return this;
    }

    @Override
    public ArtifactRepository getLocalRepository() {
        return this.repositoryRequest.getLocalRepository();
    }

    @Override
    public DefaultMetadataResolutionRequest setLocalRepository(ArtifactRepository localRepository) {
        this.repositoryRequest.setLocalRepository(localRepository);
        return this;
    }

    @Override
    public List<ArtifactRepository> getRemoteRepositories() {
        return this.repositoryRequest.getRemoteRepositories();
    }

    @Override
    public DefaultMetadataResolutionRequest setRemoteRepositories(List<ArtifactRepository> remoteRepositories) {
        this.repositoryRequest.setRemoteRepositories(remoteRepositories);
        return this;
    }

    @Override
    public boolean isResolveManagedVersions() {
        return this.resolveManagedVersions;
    }

    @Override
    public DefaultMetadataResolutionRequest setResolveManagedVersions(boolean resolveManagedVersions) {
        this.resolveManagedVersions = resolveManagedVersions;
        return this;
    }

    @Override
    public RepositoryCache getCache() {
        return this.repositoryRequest.getCache();
    }

    @Override
    public DefaultMetadataResolutionRequest setCache(RepositoryCache cache) {
        this.repositoryRequest.setCache(cache);
        return this;
    }

    @Override
    public boolean isOffline() {
        return this.repositoryRequest.isOffline();
    }

    @Override
    public DefaultMetadataResolutionRequest setOffline(boolean offline) {
        this.repositoryRequest.setOffline(offline);
        return this;
    }

    @Override
    public boolean isForceUpdate() {
        return this.repositoryRequest.isForceUpdate();
    }

    @Override
    public DefaultMetadataResolutionRequest setForceUpdate(boolean forceUpdate) {
        this.repositoryRequest.setForceUpdate(forceUpdate);
        return this;
    }

    @Override
    public ArtifactTransferListener getTransferListener() {
        return this.repositoryRequest.getTransferListener();
    }

    @Override
    public DefaultMetadataResolutionRequest setTransferListener(ArtifactTransferListener transferListener) {
        this.repositoryRequest.setTransferListener(transferListener);
        return this;
    }

    @Override
    public MetadataResolutionRequest setServers(List<Server> servers) {
        this.servers = servers;
        return this;
    }

    @Override
    public List<Server> getServers() {
        if (this.servers == null) {
            this.servers = new ArrayList<Server>();
        }
        return this.servers;
    }

    @Override
    public MetadataResolutionRequest setMirrors(List<Mirror> mirrors) {
        this.mirrors = mirrors;
        return this;
    }

    @Override
    public List<Mirror> getMirrors() {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList<Mirror>();
        }
        return this.mirrors;
    }

    @Override
    public MetadataResolutionRequest setProxies(List<Proxy> proxies) {
        this.proxies = proxies;
        return this;
    }

    @Override
    public List<Proxy> getProxies() {
        if (this.proxies == null) {
            this.proxies = new ArrayList<Proxy>();
        }
        return this.proxies;
    }
}

