/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.integration.jbossas;

//$Id$

import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

/**
 * JBossAS intergration of the TransactionManager and UserTransaction service.
 * 
 * @author thomas.diesler@jboss.com
 * @since 31-Oct-2009
 */
public class TransactionServiceBean
{
   private BundleContext context;
   private TransactionManager transactionManager;
   private UserTransaction userTransaction;
   
   private ServiceRegistration txManagerRegistration;
   private ServiceRegistration userTxRegistration;

   public void setBundleContext(BundleContext bundleContext)
   {
      this.context = bundleContext;
   }

   public void setTransactionManager(TransactionManager transactionManager)
   {
      this.transactionManager = transactionManager;
   }

   public void setUserTransaction(UserTransaction userTransaction)
   {
      this.userTransaction = userTransaction;
   }

   public void start() throws Exception
   {
      txManagerRegistration = context.registerService(TransactionManager.class.getName(), transactionManager, null);
      userTxRegistration = context.registerService(UserTransaction.class.getName(), userTransaction, null);
   }

   void stop()
   {
      if (txManagerRegistration != null)
         txManagerRegistration.unregister();
      
      if (userTxRegistration != null)
         userTxRegistration.unregister();
   }
}