package org.jboss.as.naming.javaee;

import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEApplicationInformer;

/**
 * @author <a href="cdewolf@redhat.com">Carlo de Wolf</a>
 */
public class NamingJavaEEApplicationInformer implements JavaEEApplicationInformer
{
   private static final String REQUIRED_ATTACHMENTS[] = null;

   public String getApplicationName(DeploymentUnit deploymentUnit) throws IllegalArgumentException
   {
      if(!isJavaEEApplication(deploymentUnit))
         return null;

      String name = deploymentUnit.getSimpleName();
      return name.substring(0, name.length() - 4);
   }

   public boolean isJavaEEApplication(DeploymentUnit deploymentUnit)
   {
      // JavaEE 6.0 FR 5.2.2
      // practically everything deployed standalone is considered a JavaEEApplication in terms of naming
      return deploymentUnit.isTopLevel();
   }

   public String[] getRequiredAttachments()
   {
      return REQUIRED_ATTACHMENTS;
   }   
}
