/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.aop.test;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

import junit.framework.Test;

import org.jboss.test.JBossTestCase;

public class ProxyCacheTestCase extends JBossTestCase
{
   final static String AOP_BINDINGS = "aop-proxycache.aop";
   final static String GLOBAL_JAR = "aop-proxycache-global.sar";
   final static ObjectName GLOBAL;
   static
   {
      try
      {
         GLOBAL = new ObjectName("jboss.aop:name=GlobalProxyCacheProxyTester");
      }
      catch (Exception e)
      {
         // AutoGenerated
         throw new RuntimeException(e);
      }
   }
   
   public ProxyCacheTestCase(String name)
   {
      super(name);
   }

   private interface Scenario
   {
      void execute() throws Exception;
   }

   public void testBootStrapContainerProxy() throws Exception
   {
      Scenario scenario = new Scenario() {
         
         Set<Integer> done = new HashSet<Integer>();
   
         public void execute() throws Exception
         {
            deploy(GLOBAL_JAR);
            try
            {
               
               int id = createContainerProxy(GLOBAL, ArrayList.class.getName(), null);
               assertFalse(done.contains(id));
               done.add(id);
            }
            finally
            {
               undeploy(GLOBAL_JAR);
            }
         }
      };
      executeScenario(scenario);
   }
   
   public void testBootStrapClassContainerProxy() throws Exception
   {
      Scenario scenario = new Scenario() {

         Set<Integer> done = new HashSet<Integer>();
   
         public void execute() throws Exception
         {
            deploy(GLOBAL_JAR);
            try
            {
               
               int id = createClassProxy(GLOBAL, ArrayList.class.getName(), null);
               assertFalse(done.contains(id));
               done.add(id);
            }
            finally
            {
               undeploy(GLOBAL_JAR);
            }
         }
      };
      executeScenario(scenario);
   }
   
   private void executeScenario(Scenario scenario) throws Exception
   {
      for (int i = 0 ; i < 15 ; i++)
      {
         deploy(AOP_BINDINGS);
         try
         {
            scenario.execute();
         }
         finally
         {
            undeploy(AOP_BINDINGS);
         }
         Thread.sleep(2000);
      }
   }
   
   private int createContainerProxy(ObjectName on, String className, String[] interfaces) throws Exception
   {
      if (interfaces == null)
      {
         interfaces = new String[0];
      }
      MBeanServerConnection server = getServer();
      Object[] params = {className, interfaces};
      String[] sig = {"java.lang.String", String[].class.getName()};
      return (Integer)server.invoke(on, "createContainerProxy", params, sig);
   }

   private int createClassProxy(ObjectName on, String className, Map<String, List<String>> mixins) throws Exception
   {
      MBeanServerConnection server = getServer();
      Object[] params = {className, mixins};
      String[] sig = {"java.lang.String", Map.class.getName()};
      return (Integer)server.invoke(on, "createClassProxy", params, sig);
   }

   public static Test suite() throws Exception
   {
      //return getDeploySetup(ProxyCacheTestCase.class, "aop-containercache.aop");
      return suite(ProxyCacheTestCase.class);
   }

}
