/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.ejb3.async.test;

import junit.framework.Assert;
import junit.framework.Test;
import org.jboss.test.JBossTestCase;
import org.jboss.test.ejb3.async.AsyncCommonBusiness;
import org.jboss.test.ejb3.basic.SimpleSession;

import javax.naming.InitialContext;
import java.util.concurrent.Future;

/**
 * Test Cases to ensure the EJB 3.1 implementation of the @Asynchronous
 * feature is working as expected
 * @author <a href="mailto:andrew.rubinger@jboss.org">ALR</a>
 */
//TODO Move this to the EJB 3.1 Integration TestSuite when it becomes available
public class AsyncSessionBeanUnitTestCase
   extends JBossTestCase
{
   public static Test suite() throws Exception
   {
      Test t1 = getDeploySetup(AsyncSessionBeanUnitTestCase.class, "ejb31-async.jar");
      return t1;
   }

   public AsyncSessionBeanUnitTestCase(String name)
   {
      super(name);
   }

   public void testRemoteAsyncInvocation()
      throws Exception
   {
      InitialContext ctx = getInitialContext();
      String jndiName = "AsyncBean/remote";
      Object ref = ctx.lookup(jndiName);
      AsyncCommonBusiness bean = (AsyncCommonBusiness) ref;
      final Future<Integer> invocation =bean.getNextCounter();

         // Block and test
         final int value = invocation.get();
         Assert.assertEquals("Invocation did not return correct result", 1, value);
         log.info("Got: " + invocation);
         log.info("Invocation value: " + value);
         Assert.assertTrue("First invocation did not report as completed", invocation.isDone());
         Assert.assertFalse("Invocation should not report as cancelled", invocation.isCancelled());

   }
}