package org.jboss.weld.integration.deployer.env;

import java.util.ArrayList;
import java.util.List;

import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.weld.integration.deployer.DeployersUtils;
import org.jboss.weld.integration.deployer.env.helpers.BootstrapBean;
import org.jboss.weld.integration.injection.WeldInjector;

/**
 * Ensures that Weld is bootstrapped before the Web Application is started
 * (if this is a CDI-enabled deployment)
 *
 * @author Marius Bogoevici
 * @author Ales Justin
 */
public class WebContainterIntegrationDeployer extends AbstractSimpleRealDeployer<JBossWebMetaData>
{
   public WebContainterIntegrationDeployer()
   {
      super(JBossWebMetaData.class);
      setOutput(JBossWebMetaData.class);
   }

   @Override
   public void deploy(DeploymentUnit unit, JBossWebMetaData deployment) throws DeploymentException
   {
      if (DeployersUtils.isBootstrapBeanPresent(unit) && unit.getAttachment(DeployersUtils.WELD_FILES) != null)
      {
         String injectorName = unit.getName() + "_WBInjector";
         String bootstrapBeanName = DeployersUtils.getBootstrapBeanName(unit);

         BeanMetaDataBuilder weldInjector = BeanMetaDataBuilder.createBuilder(injectorName, WeldInjector.class.getName());

         weldInjector.addConstructorParameter(BootstrapBean.class.getName(), weldInjector.createInject(bootstrapBeanName));
         weldInjector.addConstructorParameter(String.class.getName(), unit.getClassLoader().toString());
         weldInjector.setDestroy("cleanup");
         unit.addAttachment(injectorName + "_" + BeanMetaData.class.getSimpleName(), weldInjector.getBeanMetaData());

         List<String> depends = deployment.getDepends();
         if (depends == null)
         {
            depends = new ArrayList<String>();
            deployment.setDepends(depends);
         }
         depends.add(bootstrapBeanName);
      }
   }
}
