/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.ejb.lifecycle.test;

import java.util.Collections;
import java.util.Enumeration;

import junit.framework.TestCase;

import org.jboss.test.cts.test.StatefulSessionUnitTestCase;

/**
 * LifeCycleTestCase for Stateful beans based on the cts testCase
 * @see {@linkplain StatefulSessionUnitTestCase} 
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision: 82920 $
 */
public class StatefulLifeCycleUnitTestCase extends AbstractLifeCycleTestWrapper
{

   /** The package */
   private static final String PACKAGE = "cts.jar";
   
   /** The service base name */
   private static final String NAME = "jboss.j2ee:jndiName=ejbcts/StatefulSessionBean,service=EJB";

   public StatefulLifeCycleUnitTestCase(String name)
   {
      super(name);
   }
   
   public void testRestartContainer() throws Exception
   {
      restart(NAME);
   }
   
   public void testRestartPool() throws Exception
   {
      String poolName = NAME + ",plugin=pool";
      restart(poolName);
   }
   
   public void testRestartCache() throws Exception
   {
      String cacheName = NAME + ",plugin=cache";
      restart(cacheName);
   }

   protected Enumeration<TestCase> getTests()
   {
      // disable testPassivationByTime test, as this leads to a timeout 
      return getTestCases(StatefulSessionUnitTestCase.class, Collections.singleton("testPassivationByTime"));
   }
   
   @Override
   protected String getPackage()
   {
      return PACKAGE;
   }

}