/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classpool.plugins.jbosscl;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import org.jboss.classloader.spi.ParentPolicy;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classpool.base.BaseClassPool;
import org.jboss.classpool.base.BaseClassPoolDomain;
import org.jboss.classpool.base.ParentDelegationStrategy;
import org.jboss.classpool.domain.ClassPoolDomain;
import org.jboss.classpool.helpers.ClassLoaderUtils;
import org.jboss.classpool.plugins.DelegatingClassPool;
import org.jboss.classpool.plugins.jbosscl.DomainRegistry;
import org.jboss.classpool.plugins.jbosscl.JBossClClassPoolToClassPoolDomainAdaptorFactory;
import org.jboss.classpool.plugins.jbosscl.JBossClDelegatingClassPool;
import org.jboss.classpool.plugins.jbosscl.JBossClParentDelegationStrategy;
import org.jboss.classpool.plugins.jbosscl.JBossClRegistryHandler;
import org.jboss.classpool.spi.AbstractClassPoolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JBossClClassPoolDomain
extends BaseClassPoolDomain {
    private final ConcurrentMap<String, Set<DelegatingClassPool>> poolsByPackage = new ConcurrentHashMap<String, Set<DelegatingClassPool>>();
    private final DomainRegistry registry;

    public JBossClClassPoolDomain(String domainName, ParentPolicy parentPolicy, DomainRegistry registry) {
        super(domainName, (ParentDelegationStrategy)new JBossClParentDelegationStrategy(parentPolicy, JBossClClassPoolToClassPoolDomainAdaptorFactory.getInstance()));
        this.registry = registry;
    }

    public JBossClClassPoolDomain(String domainName, ClassPoolDomain parent, ParentPolicy parentPolicy, DomainRegistry registry) {
        super(domainName, (ParentDelegationStrategy)new JBossClParentDelegationStrategy(parent, parentPolicy, JBossClClassPoolToClassPoolDomainAdaptorFactory.getInstance()));
        this.registry = registry;
    }

    public JBossClClassPoolDomain(String domainName, ClassPool parent, ParentPolicy parentPolicy, DomainRegistry registry) {
        super(domainName, (ParentDelegationStrategy)new JBossClParentDelegationStrategy(parent, parentPolicy, JBossClClassPoolToClassPoolDomainAdaptorFactory.getInstance()));
        this.registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setupPoolsByPackage(DelegatingClassPool pool) {
        if (!(pool instanceof JBossClDelegatingClassPool)) {
            throw new IllegalStateException("Not an instance of JBossClDelegatingClassPool: " + pool.getClass().getName());
        }
        Module module = this.getModuleForPool(pool);
        boolean trace = this.logger.isTraceEnabled();
        this.lockWrite();
        try {
            for (String pkg : module.getPackageNames()) {
                Set old;
                Set<Object> pools = (LinkedHashSet<DelegatingClassPool>)this.poolsByPackage.get(pkg);
                if (pools == null && (old = (Set)this.poolsByPackage.putIfAbsent(pkg, pools = new LinkedHashSet<DelegatingClassPool>())) != null) {
                    pools = old;
                }
                pools.add(pool);
                if (!trace) continue;
                this.logger.trace((Object)((Object)((Object)this) + " adding package " + pkg + " for pool " + pool));
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClassPool(DelegatingClassPool pool) {
        super.removeClassPool(pool);
        Module module = this.getModuleForPool(pool);
        boolean trace = this.logger.isTraceEnabled();
        this.lockWrite();
        try {
            for (String pkg : module.getPackageNames()) {
                Set pools = (Set)this.poolsByPackage.get(pkg);
                if (pools == null) continue;
                pools.remove(pool);
                if (pools.size() != 0) continue;
                this.poolsByPackage.remove(pkg);
                if (!trace) continue;
                this.logger.trace((Object)((Object)((Object)this) + " removing package " + pkg + " for pool " + pool));
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    public CtClass getCachedOrCreate(DelegatingClassPool initiatingPool, String classname, String resourceName, boolean create, boolean trace) {
        CtClass clazz;
        if (trace) {
            this.logger.trace((Object)((Object)((Object)this) + " looking for " + classname));
        }
        if ((clazz = this.getCheckPrimitive(classname)) != null) {
            if (trace) {
                this.logger.trace((Object)((Object)((Object)this) + " isPrimitive " + classname));
            }
        } else {
            Module module = this.getModuleForPool(initiatingPool);
            if (module != null && module.isImportAll()) {
                if (trace) {
                    this.logger.trace((Object)((Object)((Object)this) + " isImportAll"));
                }
                return super.getCachedOrCreate(initiatingPool, classname, resourceName, create, trace);
            }
            if (this.isParentBefore(classname)) {
                if (trace) {
                    this.logger.trace((Object)((Object)((Object)this) + " checking parent first for " + classname));
                }
                clazz = this.getCachedOrCreateFromParent(null, classname, resourceName, create, trace);
            }
            if (clazz == null && module != null) {
                if (trace) {
                    this.logger.trace((Object)((Object)((Object)this) + " checking imports for " + classname));
                }
                clazz = this.getCtClassFromModule(module, classname, trace);
            }
            if (clazz == null && initiatingPool != null) {
                if (trace) {
                    this.logger.trace((Object)((Object)((Object)this) + " checking pool " + initiatingPool + " locally for " + classname));
                }
                clazz = initiatingPool.loadLocally(classname, resourceName, create);
            }
            if (clazz == null && this.isParentAfter(classname)) {
                if (trace) {
                    this.logger.trace((Object)((Object)((Object)this) + " checking parent last for " + classname));
                }
                clazz = this.getCachedOrCreateFromParent(null, classname, resourceName, create, trace);
            }
        }
        if (trace) {
            this.logger.trace((Object)((Object)((Object)this) + " found " + classname + " in " + (clazz == null ? "null" : clazz.getClassPool())));
        }
        return clazz;
    }

    private CtClass getCheckPrimitive(String classname) {
        if (ClassLoaderUtils.isPrimitiveType((String)classname)) {
            try {
                return AbstractClassPoolFactory.getSystemClassPool().get(classname);
            }
            catch (NotFoundException e) {
                throw new RuntimeException(classname + " should have been a primitive", e);
            }
        }
        return null;
    }

    private Module getModuleForPool(DelegatingClassPool pool) {
        if (pool == null) {
            return null;
        }
        Module module = ((JBossClDelegatingClassPool)pool).getModule();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)((Object)((Object)this) + " got module " + module + " for " + pool));
        }
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<DelegatingClassPool> getPoolsForClassName(String classname) {
        String packageName = ClassLoaderUtils.getPackageName((String)classname);
        Set poolSet = (Set)this.poolsByPackage.get(packageName);
        this.lockRead();
        try {
            ArrayList<DelegatingClassPool> arrayList = poolSet == null ? Collections.emptyList() : new ArrayList<DelegatingClassPool>(poolSet);
            return arrayList;
        }
        finally {
            this.unlockRead();
        }
    }

    private CtClass getCtClassFromModule(final Module module, final String classname, boolean trace) {
        Module found;
        block7: {
            found = null;
            try {
                found = AccessController.doPrivileged(new PrivilegedExceptionAction<Module>(){

                    @Override
                    public Module run() throws Exception {
                        return module.getModuleForClass(ClassLoaderUtils.stripArrayFromClassName((String)classname));
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof ClassNotFoundException) break block7;
                throw new RuntimeException(e);
            }
        }
        if (trace) {
            this.logger.trace((Object)((Object)((Object)this) + " module for " + classname + " " + found));
        }
        if (found == null || found == module) {
            return null;
        }
        ClassLoader foundLoader = this.registry.getClassLoader(found);
        ClassPool pool = JBossClRegistryHandler.getInstance().registerClassLoader(foundLoader);
        try {
            if (pool instanceof BaseClassPool) {
                return this.getCachedOrCreateFromPool((BaseClassPool)pool, classname, true, trace);
            }
            return pool.get(classname);
        }
        catch (NotFoundException ignore) {
            return null;
        }
    }
}

