/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.nointerface.impl.jndi;

import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.ejb3.nointerface.impl.jndi.AbstractNoInterfaceViewBinder;
import org.jboss.ejb3.nointerface.impl.objectfactory.StatefulNoInterfaceViewObjectFactory;
import org.jboss.ejb3.nointerface.impl.view.factory.StatefulNoInterfaceViewProxyFactory;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;
import org.jboss.util.naming.NonSerializableFactory;
import org.jboss.util.naming.Util;

public class StatefulBeanNoInterfaceViewBinder
extends AbstractNoInterfaceViewBinder {
    private static Logger logger = Logger.getLogger(StatefulBeanNoInterfaceViewBinder.class);
    private static final String NO_INTERFACE_STATEFUL_PROXY_FACTORY_JNDI_NAME_SUFFIX = "_no-interface-stateful-proxyfactory";

    public StatefulBeanNoInterfaceViewBinder(Context jndiCtx, String jndiName, Class<?> beanClass, JBossSessionBean31MetaData beanMetaData) {
        super(jndiCtx, jndiName, beanClass, beanMetaData);
    }

    @Override
    public void bind() throws NamingException {
        if (this.endpointContext == null) {
            throw new IllegalStateException("KernelControllerContext hasn't been set for nointerface view binder of bean: " + this.beanClass);
        }
        StatefulNoInterfaceViewProxyFactory statefulNoInterfaceViewFactory = new StatefulNoInterfaceViewProxyFactory(this.beanClass, this.endpointContext, this.sessionBeanMetaData);
        String statefulProxyFactoryJndiName = this.noInterfaceViewJNDIName + NO_INTERFACE_STATEFUL_PROXY_FACTORY_JNDI_NAME_SUFFIX;
        NonSerializableFactory.rebind((Context)this.jndiContext, (String)statefulProxyFactoryJndiName, (Object)statefulNoInterfaceViewFactory, (boolean)true);
        Reference reference = new Reference("Object factory for no-interface view for stateful bean", StatefulNoInterfaceViewObjectFactory.class.getName(), null);
        StringRefAddr refAddr = new StringRefAddr("Stateful Proxy factory for no-interface view", statefulProxyFactoryJndiName);
        reference.add(refAddr);
        this.prettyPrintJNDIBindingInfo();
        Util.bind((Context)this.jndiContext, (String)this.noInterfaceViewJNDIName, (Object)reference);
    }

    @Override
    public void unbind() throws NamingException {
        this.jndiContext.unbind(this.noInterfaceViewJNDIName);
        this.jndiContext.unbind(this.noInterfaceViewJNDIName + NO_INTERFACE_STATEFUL_PROXY_FACTORY_JNDI_NAME_SUFFIX);
    }
}

