/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.core.management;

import org.hornetq.utils.json.JSONArray;
import org.hornetq.utils.json.JSONObject;

public class RoleInfo {
    private final String name;
    private final boolean send;
    private final boolean consume;
    private final boolean createDurableQueue;
    private final boolean deleteDurableQueue;
    private final boolean createNonDurableQueue;
    private final boolean deleteNonDurableQueue;
    private final boolean manage;

    public static final RoleInfo[] from(String jsonString) throws Exception {
        JSONArray array = new JSONArray(jsonString);
        RoleInfo[] roles = new RoleInfo[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            RoleInfo role;
            JSONObject r = array.getJSONObject(i);
            roles[i] = role = new RoleInfo(r.getString("name"), r.getBoolean("send"), r.getBoolean("consume"), r.getBoolean("createDurableQueue"), r.getBoolean("deleteDurableQueue"), r.getBoolean("createNonDurableQueue"), r.getBoolean("deleteNonDurableQueue"), r.getBoolean("manage"));
        }
        return roles;
    }

    private RoleInfo(String name, boolean send, boolean consume, boolean createDurableQueue, boolean deleteDurableQueue, boolean createNonDurableQueue, boolean deleteNonDurableQueue, boolean manage) {
        this.name = name;
        this.send = send;
        this.consume = consume;
        this.createDurableQueue = createDurableQueue;
        this.deleteDurableQueue = deleteDurableQueue;
        this.createNonDurableQueue = createNonDurableQueue;
        this.deleteNonDurableQueue = deleteNonDurableQueue;
        this.manage = manage;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSend() {
        return this.send;
    }

    public boolean isConsume() {
        return this.consume;
    }

    public boolean isCreateDurableQueue() {
        return this.createDurableQueue;
    }

    public boolean isDeleteDurableQueue() {
        return this.deleteDurableQueue;
    }

    public boolean isCreateNonDurableQueue() {
        return this.createNonDurableQueue;
    }

    public boolean isDeleteNonDurableQueue() {
        return this.deleteNonDurableQueue;
    }

    public boolean isManage() {
        return this.manage;
    }
}

