/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.callback;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.callback.CallbackStoreMBean;
import org.jboss.remoting.serialization.SerializationStreamFactory;
import org.jboss.remoting.util.SecurityUtility;

public class CallbackStore
implements CallbackStoreMBean {
    private static long previousTimestamp;
    private static int timestampCounter;
    private String filePath = null;
    private String fileSuffix = "ser";
    private boolean isStarted = false;
    private boolean purgeOnShutdown = false;
    private String serializationType = "java";
    public static final String FILE_PATH_KEY = "StoreFilePath";
    public static final String FILE_SUFFIX_KEY = "StoreFileSuffix";
    private static final Logger log;

    public CallbackStore() {
    }

    public CallbackStore(boolean purgeOnDestroy) {
        this.purgeOnShutdown = purgeOnDestroy;
    }

    @Override
    public void start() throws Exception {
        if (!this.isStarted) {
            boolean madeDir;
            File storeFile;
            if (this.filePath == null) {
                try {
                    this.filePath = CallbackStore.getSystemProperty("jboss.server.data.dir", "data");
                }
                catch (Exception e) {
                    log.debug((Object)"error", (Throwable)e);
                    this.filePath = "data";
                }
            }
            if (!(storeFile = new File(this.filePath)).exists() && !(madeDir = CallbackStore.mkdirs(storeFile))) {
                throw new IOException("Can not create directory for store.  Path given: " + this.filePath);
            }
            this.isStarted = true;
        }
    }

    @Override
    public void setPurgeOnShutdown(boolean purgeOnShutdown) {
        this.purgeOnShutdown = purgeOnShutdown;
    }

    @Override
    public boolean getPurgeOnShutdown() {
        return this.purgeOnShutdown;
    }

    @Override
    public void create() throws Exception {
    }

    @Override
    public void stop() {
        this.isStarted = false;
    }

    @Override
    public void destroy() {
        if (this.purgeOnShutdown) {
            this.purgeFiles();
        }
    }

    @Override
    public void purgeFiles() {
        String[] fileList = this.getObjectFileList();
        String fileToDelete = null;
        for (int x = 0; x < fileList.length; ++x) {
            try {
                String separator = CallbackStore.getSystemProperty("file.separator");
                fileToDelete = this.filePath + separator + fileList[x];
                final File currentFile = new File(fileToDelete);
                boolean deleted = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new Boolean(currentFile.delete());
                    }
                });
                if (deleted) continue;
                log.warn((Object)("Error purging file " + fileToDelete));
                continue;
            }
            catch (Exception e) {
                log.warn((Object)("Error purging file " + fileToDelete));
            }
        }
    }

    @Override
    public void setConfig(Map config) {
        if (config != null) {
            String newSerializationType;
            String newFileSuffix;
            String newFilePath = (String)config.get(FILE_PATH_KEY);
            if (newFilePath != null) {
                this.filePath = newFilePath;
            }
            if ((newFileSuffix = (String)config.get(FILE_SUFFIX_KEY)) != null) {
                this.fileSuffix = newFileSuffix;
            }
            if ((newSerializationType = (String)config.get("serializationtype")) != null) {
                this.serializationType = newSerializationType;
            }
        }
    }

    @Override
    public String getStoreFilePath() {
        return this.filePath;
    }

    @Override
    public void setStoreFilePath(String filePath) {
        this.filePath = filePath;
    }

    @Override
    public String getStoreFileSuffix() {
        return this.fileSuffix;
    }

    @Override
    public void setStoreFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    @Override
    public int size() {
        this.verifyStarted();
        String[] objectFileList = this.getObjectFileList();
        if (objectFileList != null) {
            return objectFileList.length;
        }
        return 0;
    }

    private void verifyStarted() {
        if (!this.isStarted) {
            throw new RuntimeException("Can not call upon this store method before it has been started.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getNext() throws IOException {
        this.verifyStarted();
        Object obj = null;
        String objectFilePath = null;
        String string = this.filePath;
        synchronized (string) {
            String[] objectFileList = this.getObjectFileList();
            FileInputStream inFile = null;
            ObjectInputStream in = null;
            if (objectFileList != null && objectFileList.length > 0) {
                block23: {
                    try {
                        String separator = CallbackStore.getSystemProperty("file.separator");
                        objectFilePath = this.filePath + separator + objectFileList[0];
                        inFile = CallbackStore.getFileInputStream(objectFilePath);
                        in = SerializationStreamFactory.getManagerInstance(this.serializationType).createRegularInput(inFile);
                        try {
                            obj = in.readObject();
                        }
                        catch (ClassNotFoundException e) {
                            throw new IOException("Error loading persisted object.  Could not load class (" + e.getMessage() + ").");
                        }
                        if (inFile == null) break block23;
                    }
                    catch (Throwable throwable) {
                        if (inFile != null) {
                            try {
                                inFile.close();
                            }
                            catch (IOException ioe) {
                                log.debug((Object)"Error closing FileInputStream.", (Throwable)ioe);
                            }
                        }
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException ioe) {
                                log.debug((Object)"Error closing ObjectInputStream.", (Throwable)ioe);
                            }
                        }
                        if (objectFilePath != null) {
                            File objectFile = new File(objectFilePath);
                            boolean isDeleted = (Boolean)AccessController.doPrivileged(new PrivilegedAction(objectFile){
                                final /* synthetic */ File val$objectFile;
                                {
                                    this.val$objectFile = file;
                                }

                                public Object run() {
                                    return new Boolean(this.val$objectFile.delete());
                                }
                            });
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("object file (" + objectFilePath + ") has been deleted - " + isDeleted));
                            }
                        }
                        throw throwable;
                    }
                    try {
                        inFile.close();
                    }
                    catch (IOException ioe) {
                        log.debug((Object)"Error closing FileInputStream.", (Throwable)ioe);
                    }
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {
                        log.debug((Object)"Error closing ObjectInputStream.", (Throwable)ioe);
                    }
                }
                if (objectFilePath != null) {
                    File objectFile = new File(objectFilePath);
                    boolean isDeleted = (Boolean)AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("object file (" + objectFilePath + ") has been deleted - " + isDeleted));
                    }
                }
            }
        }
        return obj;
    }

    private String[] getObjectFileList() {
        final File storePath = new File(this.filePath);
        Object[] objectFileList = (String[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return storePath.list(new StoreFileFilter());
            }
        });
        Arrays.sort(objectFileList);
        return objectFileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(final Serializable object) throws IOException {
        this.verifyStarted();
        String string = this.filePath;
        synchronized (string) {
            block21: {
                long currentTimestamp = System.currentTimeMillis();
                if (previousTimestamp == currentTimestamp) {
                    ++timestampCounter;
                } else {
                    previousTimestamp = currentTimestamp;
                    timestampCounter = 0;
                }
                StringBuffer path = new StringBuffer(this.filePath);
                String separator = CallbackStore.getSystemProperty("file.separator");
                path.append(separator).append(String.valueOf(currentTimestamp));
                path.append("-").append(timestampCounter).append(".").append(this.fileSuffix);
                File storeFile = new File(path.toString());
                FileOutputStream outFile = null;
                ObjectOutputStream out = null;
                try {
                    outFile = CallbackStore.getFileOutputStream(storeFile, false);
                    if (this.serializationType.indexOf("jboss") > 0) {
                        out = SerializationStreamFactory.getManagerInstance(this.serializationType).createOutput(outFile);
                        out.writeObject(object);
                        out.flush();
                        break block21;
                    }
                    try {
                        final FileOutputStream finalOutFile = outFile;
                        out = (ObjectOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws IOException {
                                ObjectOutputStream out = SerializationStreamFactory.getManagerInstance(CallbackStore.this.serializationType).createOutput(finalOutFile);
                                out.writeObject(object);
                                out.flush();
                                return out;
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        throw (IOException)e.getCause();
                    }
                }
                finally {
                    if (outFile != null) {
                        try {
                            outFile.close();
                        }
                        catch (IOException ioe) {
                            log.debug((Object)"Error closing FileInputStream.", (Throwable)ioe);
                        }
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException ioe) {
                            log.debug((Object)"Error closing ObjectInputStream.", (Throwable)ioe);
                        }
                    }
                }
            }
        }
    }

    private static boolean mkdirs(final File dir) {
        if (SecurityUtility.skipAccessControl()) {
            return dir.mkdirs();
        }
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(dir.mkdirs());
            }
        });
    }

    private static FileInputStream getFileInputStream(final String path) throws FileNotFoundException {
        if (SecurityUtility.skipAccessControl()) {
            return new FileInputStream(path);
        }
        try {
            return (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileInputStream(path);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getCause();
        }
    }

    private static FileOutputStream getFileOutputStream(final File file, final boolean append) throws FileNotFoundException {
        if (SecurityUtility.skipAccessControl()) {
            return new FileOutputStream(file, append);
        }
        try {
            return (FileOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileOutputStream(file, append);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getCause();
        }
    }

    private static String getSystemProperty(final String name, final String defaultValue) {
        if (SecurityUtility.skipAccessControl()) {
            return System.getProperty(name, defaultValue);
        }
        String value = null;
        try {
            value = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return System.getProperty(name, defaultValue);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (RuntimeException)e.getCause();
        }
        return value;
    }

    private static String getSystemProperty(final String name) {
        if (SecurityUtility.skipAccessControl()) {
            return System.getProperty(name);
        }
        String value = null;
        try {
            value = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return System.getProperty(name);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (RuntimeException)e.getCause();
        }
        return value;
    }

    static {
        log = Logger.getLogger(CallbackStore.class);
    }

    public class StoreFileFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(CallbackStore.this.fileSuffix);
        }
    }
}

