/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.bytecode.accessor.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jboss.reflect.plugins.bytecode.BytecodeConstructorInfo;
import org.jboss.reflect.plugins.bytecode.BytecodeFieldInfo;
import org.jboss.reflect.plugins.bytecode.BytecodeMethodInfo;
import org.jboss.reflect.plugins.bytecode.BytecodeTypeInfo;
import org.jboss.reflect.plugins.bytecode.accessor.ConstructorAccessor;
import org.jboss.reflect.plugins.bytecode.accessor.FieldAccessor;
import org.jboss.reflect.plugins.bytecode.accessor.MethodAccessor;
import org.jboss.reflect.plugins.bytecode.accessor.reflect.ReflectConstructorAccessor;
import org.jboss.reflect.plugins.bytecode.accessor.reflect.ReflectFieldAccessor;
import org.jboss.reflect.plugins.bytecode.accessor.reflect.ReflectMethodAccessor;
import org.jboss.reflect.spi.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectAccessorFactory {
    private static final Class<?>[] NO_PARAMS = new Class[0];

    public static MethodAccessor createMethodAccessor(BytecodeMethodInfo methodInfo) {
        if (methodInfo == null) {
            throw new IllegalArgumentException("Null method");
        }
        try {
            Class<? extends Object> clazz = ((BytecodeTypeInfo)methodInfo.getDeclaringClass()).getType();
            Class<?>[] params = ReflectAccessorFactory.getParams(methodInfo.getParameterTypes());
            Method method = clazz.getDeclaredMethod(methodInfo.getName(), params);
            return new ReflectMethodAccessor(method);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ConstructorAccessor createConstructorAccessor(BytecodeConstructorInfo constructorInfo) {
        if (constructorInfo == null) {
            throw new IllegalArgumentException("Null constructor");
        }
        try {
            Class<? extends Object> clazz = ((BytecodeTypeInfo)constructorInfo.getDeclaringClass()).getType();
            Class<?>[] params = ReflectAccessorFactory.getParams(constructorInfo.getParameterTypes());
            Constructor<? extends Object> ctor = clazz.getDeclaredConstructor(params);
            return new ReflectConstructorAccessor(ctor);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static FieldAccessor createFieldAccessor(BytecodeFieldInfo fieldInfo) {
        if (fieldInfo == null) {
            throw new IllegalArgumentException("Null field");
        }
        try {
            Class<? extends Object> clazz = fieldInfo.getDeclaringClass().getType();
            Field field = clazz.getDeclaredField(fieldInfo.getName());
            return new ReflectFieldAccessor(field);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<?>[] getParams(TypeInfo[] typeParams) {
        if (typeParams == null || typeParams.length == 0) {
            return NO_PARAMS;
        }
        Class[] params = new Class[typeParams.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = typeParams[i].getType();
        }
        return params;
    }
}

