/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.request.GetAssertionStatusReport;
import org.apache.juddi.datatype.response.CompletionStatus;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class GetAssertionStatusReportHandler
extends AbstractHandler {
    public static final String TAG_NAME = "get_assertionStatusReport";
    private HandlerMaker maker = null;

    protected GetAssertionStatusReportHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        GetAssertionStatusReport obj = new GetAssertionStatusReport();
        Vector nodeList = null;
        AbstractHandler handler = null;
        String generic = element.getAttribute("generic");
        if (generic != null && generic.trim().length() > 0) {
            obj.setGeneric(generic);
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "authInfo")).size() > 0) {
            handler = this.maker.lookup("authInfo");
            obj.setAuthInfo((AuthInfo)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "completionStatus")).size() > 0) {
            handler = this.maker.lookup("completionStatus");
            obj.setCompletionStatus((CompletionStatus)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        String status;
        AuthInfo authInfo;
        GetAssertionStatusReport request = (GetAssertionStatusReport)object;
        Element element = parent.getOwnerDocument().createElementNS(null, TAG_NAME);
        AbstractHandler handler = null;
        String generic = request.getGeneric();
        if (generic != null) {
            element.setAttribute("generic", generic);
        }
        if ((authInfo = request.getAuthInfo()) != null) {
            handler = this.maker.lookup("authInfo");
            handler.marshal(authInfo, element);
        }
        if ((status = request.getCompletionStatus()) != null) {
            handler = this.maker.lookup("completionStatus");
            handler.marshal(new CompletionStatus(status), element);
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        AuthInfo authInfo = new AuthInfo();
        authInfo.setValue("6f157513-844e-4a95-a856-d257e6ba9726");
        GetAssertionStatusReport service = new GetAssertionStatusReport();
        service.setAuthInfo(authInfo);
        service.setCompletionStatus("status:complete");
        System.out.println();
        RegistryObject regObject = service;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

