/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import javax.annotation.security.DeclareRoles;
import org.jboss.annotation.javaee.Descriptions;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;

public class DeclareRolesProcessor
extends AbstractFinderUser
implements Processor<SecurityRolesMetaData, Class<?>> {
    public DeclareRolesProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    @Override
    public void process(SecurityRolesMetaData metaData, Class<?> element) {
        DeclareRoles roles = this.finder.getAnnotation(element, DeclareRoles.class);
        if (roles == null) {
            return;
        }
        for (String role : roles.value()) {
            SecurityRoleMetaData sr = new SecurityRoleMetaData();
            sr.setRoleName(role);
            Descriptions descriptions = ProcessorUtils.getDescription("DeclareRoles(" + roles.value() + ") on class: " + element.getName());
            sr.setDescriptions(descriptions);
            metaData.add(sr);
        }
    }

    @Override
    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(DeclareRoles.class);
    }
}

