/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.ClientHolder;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.transport.ClientInvoker;

public class LeasePinger {
    private static final Logger log = Logger.getLogger(LeasePinger.class);
    public static final long DEFAULT_LEASE_PERIOD = 5000L;
    public static final int DEFAULT_DISCONNECT_TIMEOUT = -1;
    public static final String LEASE_PINGER_TIMEOUT = "leasePingerTimeout";
    static final String LEASE_PINGER_ID = "leasePingerId";
    static final String TIME_STAMP = "timeStamp";
    private static boolean trace = log.isTraceEnabled();
    private static Timer timer = new Timer(true);
    private long defaultPingPeriod = -1L;
    private ClientInvoker invoker = null;
    private String invokerSessionID = null;
    private Map clientSessionIds = new ConcurrentHashMap();
    private Map clients = new ConcurrentHashMap();
    private TimerTask timerTask = null;
    private long pingPeriod = -1L;
    private int disconnectTimeout = -1;
    private int leasePingerTimeout = -1;
    private boolean pingInvoked;
    private boolean pingSucceeded;
    private String leasePingerId;
    private boolean useClientConnectionIdentity;

    public LeasePinger(ClientInvoker invoker, String invokerSessionID, long defaultLeasePeriod) {
        this(invoker, invokerSessionID, defaultLeasePeriod, null);
    }

    public LeasePinger(ClientInvoker invoker, String invokerSessionID, long defaultLeasePeriod, Map config) {
        Object o;
        this.invoker = invoker;
        this.invokerSessionID = invokerSessionID;
        this.pingPeriod = defaultLeasePeriod;
        this.defaultPingPeriod = defaultLeasePeriod;
        if (config != null && (o = config.get(LEASE_PINGER_TIMEOUT)) != null) {
            if (o instanceof String) {
                try {
                    this.leasePingerTimeout = Integer.valueOf((String)o);
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("leasePingerTimeout parameter must represent an int: " + o));
                }
            } else {
                log.warn((Object)"leasePingerTimeout parameter must be a String representing an int");
            }
        }
    }

    public void startPing() {
        if (trace) {
            log.trace((Object)(this + " starting lease timer with ping period of " + this.pingPeriod));
        }
        this.timerTask = new LeaseTimerTask(this);
        try {
            timer.schedule(this.timerTask, this.pingPeriod, this.pingPeriod);
        }
        catch (IllegalStateException e) {
            log.debug((Object)"Unable to schedule TimerTask on existing Timer", (Throwable)e);
            timer = new Timer(true);
            timer.schedule(this.timerTask, this.pingPeriod, this.pingPeriod);
        }
    }

    public void stopPing() {
        if (trace) {
            log.trace((Object)(this + " stopping lease timer"));
        }
        if (this.timerTask != null) {
            Iterator<Object> it;
            this.timerTask.cancel();
            this.timerTask = null;
            if (this.useClientConnectionIdentity) {
                it = this.clients.values().iterator();
                while (it.hasNext()) {
                    Client client = (Client)it.next();
                    if (trace) {
                        log.trace((Object)(this + " calling " + client + ".notifyAndDisconnect()"));
                    }
                    client.notifyListeners();
                    it.remove();
                }
            }
            try {
                HashMap<String, String> metadata = null;
                if (trace) {
                    log.trace((Object)(this + ": disconnectTimeout: " + this.disconnectTimeout));
                }
                if (this.disconnectTimeout != 0) {
                    if (this.disconnectTimeout > 0) {
                        metadata = new HashMap<String, String>(1);
                        metadata.put("timeout", Integer.toString(this.disconnectTimeout));
                    }
                    InvocationRequest ir = new InvocationRequest(this.invokerSessionID, null, "$DISCONNECT$", metadata, null, null);
                    this.invoker.invoke(ir);
                }
            }
            catch (Throwable throwable) {
                RuntimeException e = new RuntimeException("Error tearing down lease with server.");
                e.initCause(throwable);
                throw e;
            }
            if (trace) {
                log.trace((Object)(this + " shut down"));
                if (!this.clientSessionIds.isEmpty()) {
                    log.trace((Object)(this + " " + this.clientSessionIds.size() + " remaining clients:"));
                    it = this.clientSessionIds.keySet().iterator();
                    while (it.hasNext()) {
                        log.trace((Object)(this + ": " + it.next()));
                    }
                    this.clientSessionIds.clear();
                } else {
                    log.trace((Object)(this + " No remaining clients"));
                }
            }
        }
    }

    public void addClient(String sessionID, Map configuration, long leasePeriod) {
        Client client;
        if (leasePeriod <= 0L) {
            leasePeriod = this.defaultPingPeriod;
        }
        if (trace) {
            log.trace((Object)(this + " adding new client with session ID " + sessionID + " and lease period " + leasePeriod));
        }
        if (this.useClientConnectionIdentity && (client = (Client)configuration.remove("client")) != null) {
            this.clients.put(sessionID, client);
        }
        ClientHolder newClient = new ClientHolder(sessionID, configuration, leasePeriod);
        this.clientSessionIds.put(sessionID, newClient);
        try {
            this.sendClientPing();
        }
        catch (Throwable t) {
            log.debug((Object)(this + " failed to ping to server"), t);
            log.warn((Object)(this + " failed to ping to server: " + t.getMessage()));
            throw new RuntimeException(t);
        }
        if (leasePeriod < this.pingPeriod) {
            this.pingPeriod = leasePeriod;
            if (this.timerTask != null) {
                this.timerTask.cancel();
                this.timerTask = null;
                this.startPing();
            }
        }
    }

    public boolean removeClient(String sessionID) {
        ClientHolder holder;
        boolean isLastClientLease = false;
        if (trace) {
            log.trace((Object)(this + " removing client with session ID " + sessionID));
        }
        if ((holder = (ClientHolder)this.clientSessionIds.get(sessionID)) != null) {
            try {
                HashMap<String, Object> clientMap = new HashMap<String, Object>();
                clientMap.put("ClientHolderKey", holder);
                if (this.disconnectTimeout != 0) {
                    if (this.disconnectTimeout > 0) {
                        clientMap.put("timeout", Integer.toString(this.disconnectTimeout));
                    }
                    InvocationRequest ir = new InvocationRequest(this.invokerSessionID, null, "$DISCONNECT$", clientMap, null, null);
                    this.invoker.invoke(ir);
                    if (trace) {
                        log.trace((Object)(this + " sent out disconnect message to server for lease tied to client with session ID " + sessionID));
                    }
                }
            }
            catch (Throwable throwable) {
                log.debug((Object)(this + " failed sending disconnect for client lease for " + "client with session ID " + sessionID));
            }
            this.clientSessionIds.remove(sessionID);
            if (this.useClientConnectionIdentity) {
                this.clients.remove(sessionID);
            }
        } else {
            log.debug((Object)(this + " tried to remove lease for client with session ID " + sessionID + ", but no such lease was found: probably it was registered with an older LeasePinger"));
        }
        if (this.clientSessionIds.isEmpty()) {
            isLastClientLease = true;
            if (trace) {
                log.trace((Object)(this + " has no more client leases"));
            }
        } else {
            long tempPingPeriod = this.defaultPingPeriod;
            for (ClientHolder clientHolder : this.clientSessionIds.values()) {
                long clientHolderLeasePeriod = clientHolder.getLeasePeriod();
                if (clientHolderLeasePeriod <= 0L || clientHolderLeasePeriod >= tempPingPeriod) continue;
                tempPingPeriod = clientHolderLeasePeriod;
            }
            if (tempPingPeriod != this.pingPeriod) {
                this.pingPeriod = tempPingPeriod;
                if (this.timerTask != null) {
                    this.timerTask.cancel();
                    this.timerTask = null;
                }
                this.startPing();
            }
        }
        return isLastClientLease;
    }

    public long getLeasePeriod(String sessionID) {
        if (this.timerTask == null) {
            return -1L;
        }
        if (this.clientSessionIds.containsKey(sessionID)) {
            return this.pingPeriod;
        }
        return -1L;
    }

    public String toString() {
        return "LeasePinger[" + this.leasePingerId + ":" + this.invoker + "(" + this.invokerSessionID + ")]";
    }

    protected int getDisconnectTimeout() {
        return this.disconnectTimeout;
    }

    protected void setDisconnectTimeout(int disconnectTimeout) {
        this.disconnectTimeout = disconnectTimeout;
        if (trace) {
            log.trace((Object)(this + " setting disconnect timeout to: " + disconnectTimeout));
        }
    }

    protected String getLeasePingerId() {
        return this.leasePingerId;
    }

    protected void setLeasePingerId(String leasePingerId) {
        this.leasePingerId = leasePingerId;
    }

    boolean isUseClientConnectionIdentity() {
        return this.useClientConnectionIdentity;
    }

    void setUseClientConnectionIdentity(boolean useClientConnectionIdentity) {
        this.useClientConnectionIdentity = useClientConnectionIdentity;
    }

    private void sendClientPing() throws Throwable {
        if (trace) {
            StringBuffer sb = new StringBuffer();
            if (this.clientSessionIds != null) {
                for (ClientHolder h : this.clientSessionIds.values()) {
                    sb.append("    ").append(h.getSessionId()).append('\n');
                }
            }
            log.trace((Object)(this + " sending ping to server. Currently managing lease " + "for following clients:\n" + sb.toString()));
        }
        ConcurrentHashMap clientsClone = new ConcurrentHashMap(this.clientSessionIds);
        ConcurrentHashMap requestClients = new ConcurrentHashMap();
        requestClients.put("ClientHolderKey", clientsClone);
        requestClients.put(LEASE_PINGER_ID, this.leasePingerId);
        requestClients.put(TIME_STAMP, Long.toString(System.currentTimeMillis()));
        if (this.leasePingerTimeout >= 0) {
            requestClients.put("timeout", Integer.toString(this.leasePingerTimeout));
        }
        InvocationRequest ir = new InvocationRequest(this.invokerSessionID, null, "$PING$", (Map)requestClients, null, null);
        this.pingSucceeded = false;
        this.pingInvoked = true;
        this.invoker.invoke(ir);
        this.pingSucceeded = true;
        this.pingInvoked = false;
        if (trace) {
            log.trace((Object)(this + " successfully pinged the server"));
        }
    }

    private static class LeaseTimerTask
    extends TimerTask {
        private LeasePinger pinger;

        LeaseTimerTask(LeasePinger pinger) {
            this.pinger = pinger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LeasePinger currentPinger;
            LeaseTimerTask leaseTimerTask = this;
            synchronized (leaseTimerTask) {
                currentPinger = this.pinger;
            }
            if (currentPinger != null) {
                try {
                    currentPinger.sendClientPing();
                }
                catch (Throwable t) {
                    log.debug((Object)(this + " failed to ping to server"), t);
                    log.warn((Object)(this + " failed to ping to server: " + t.getMessage()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            LeaseTimerTask leaseTimerTask = this;
            synchronized (leaseTimerTask) {
                this.pinger = null;
            }
            return super.cancel();
        }
    }
}

