/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.content.PackageDetails;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.pluginapi.util.FileUtils;
import org.rhq.core.util.ZipUtil;
import org.rhq.core.util.file.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileContentDelegate {
    private final Log log = LogFactory.getLog(FileContentDelegate.class);
    protected File directory;
    private final String fileEnding;
    private final String packageTypeName;

    public FileContentDelegate(File directory, String fileEnding, String packageTypeName) {
        this.directory = directory;
        this.fileEnding = fileEnding;
        this.packageTypeName = packageTypeName;
    }

    public String getFileEnding() {
        return this.fileEnding;
    }

    public String getPackageTypeName() {
        return this.packageTypeName;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void createContent(PackageDetails details, InputStream content, boolean unzip, boolean createBackup) {
        File contentFile = this.getPath(details);
        try {
            if (createBackup) {
                this.moveToBackup(contentFile, ".bak");
            }
            if (unzip) {
                ZipUtil.unzipFile((InputStream)content, (File)contentFile);
            } else {
                FileUtil.writeFile((InputStream)content, (File)contentFile);
            }
            details.setFileName(contentFile.getPath());
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating artifact from details: " + contentFile, e);
        }
    }

    private void moveToBackup(File contentFile, String suffix) {
        File backupFile = new File(contentFile.getAbsolutePath() + suffix);
        if (backupFile.exists() && !backupFile.delete()) {
            this.log.warn((Object)("Removing of old backup file " + backupFile + " failed "));
        }
        if (!contentFile.renameTo(backupFile)) {
            this.log.warn((Object)("Moving " + contentFile + " to backup " + backupFile + " failed"));
        }
    }

    public File getPath(PackageDetails details) {
        PackageDetailsKey key = details.getKey();
        String fileName = key.getName();
        int lastPathStart = fileName.lastIndexOf(File.separatorChar);
        if (lastPathStart > -1) {
            fileName = fileName.substring(lastPathStart + 1);
        }
        if (!fileName.endsWith(this.fileEnding)) {
            fileName = fileName + this.fileEnding;
        }
        return new File(this.directory, fileName);
    }

    public InputStream getContent(PackageDetails details) {
        File contentFile = this.getPath(details);
        try {
            return new BufferedInputStream(new FileInputStream(contentFile));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Package content not found for package " + contentFile, e);
        }
    }

    public void deleteContent(PackageDetails details) {
        File contentFile = this.getPath(details);
        if (!contentFile.exists()) {
            return;
        }
        try {
            FileUtils.purge((File)contentFile, (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to delete underlying file [" + contentFile + "] for " + details + ".", e);
        }
    }

    public Set<ResourcePackageDetails> discoverDeployedPackages() {
        return null;
    }
}

