/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.container;

import java.io.File;
import java.net.URL;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.container.WebContainer;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.impl.base.container.ContainerBase;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebContainerBase<T extends Archive<T>>
extends ContainerBase<T>
implements WebContainer<T> {
    protected WebContainerBase(Class<T> actualType, Archive<?> archive) {
        super(actualType, archive);
    }

    protected abstract ArchivePath getWebPath();

    public T setWebXML(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.setWebXML(new ClassLoaderAsset(resourceName));
    }

    public T setWebXML(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.setWebXML((Asset)new FileAsset(resource));
    }

    public T setWebXML(URL resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.setWebXML((Asset)new UrlAsset(resource));
    }

    public T setWebXML(Asset resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.addWebResource(resource, "web.xml");
    }

    public T addWebResource(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.addWebResource((Asset)new ClassLoaderAsset(resourceName), AssetUtil.getNameForClassloaderResource(resourceName));
    }

    public T addWebResource(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.addWebResource((Asset)new FileAsset(resource), resource.getName());
    }

    public T addWebResource(String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addWebResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addWebResource(File resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addWebResource((Asset)new FileAsset(resource), target);
    }

    public T addWebResource(URL resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addWebResource((Asset)new UrlAsset(resource), target);
    }

    public T addWebResource(Asset resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addWebResource(resource, (ArchivePath)new BasicPath(target));
    }

    public T addWebResource(String resourceName, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addWebResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addWebResource(File resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addWebResource((Asset)new FileAsset(resource), target);
    }

    public T addWebResource(URL resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addWebResource((Asset)new UrlAsset(resource), target);
    }

    public T addWebResource(Asset resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        BasicPath location = new BasicPath(this.getWebPath(), target);
        return this.add(resource, (ArchivePath)location);
    }

    public T addWebResources(Package resourcePackage, String ... resourceNames) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNullAndNoNullValues(resourceNames, "ResourceNames must be specified and can not container null values");
        for (String resourceName : resourceNames) {
            this.addWebResource(resourcePackage, resourceName);
        }
        return this.covarientReturn();
    }

    public T addWebResource(Package resourcePackage, String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName(resourcePackage, resourceName);
        ArchivePath target = ArchivePaths.create((String)classloaderResourceName);
        return this.addWebResource(resourcePackage, resourceName, target);
    }

    public T addWebResource(Package resourcePackage, String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addWebResource(resourcePackage, resourceName, ArchivePaths.create((String)target));
    }

    public T addWebResource(Package resourcePackage, String resourceName, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName(resourcePackage, resourceName);
        ClassLoaderAsset resource = new ClassLoaderAsset(classloaderResourceName);
        return this.addWebResource((Asset)resource, target);
    }
}

