/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reloaded.naming.deployers;

import org.jboss.beans.metadata.plugins.builder.BeanMetaDataBuilderFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEApplicationInformer;
import org.jboss.reloaded.naming.deployers.mc.MCJavaEEApplication;

public class AppNamingDeployer
extends AbstractRealDeployer {
    private JavaEEApplicationInformer informer;

    public AppNamingDeployer(JavaEEApplicationInformer informer) {
        if (informer == null) {
            throw new NullPointerException("informer is null");
        }
        this.informer = informer;
        this.setInputs(informer.getRequiredAttachments());
        this.setOutput(BeanMetaData.class);
    }

    protected void internalDeploy(DeploymentUnit deploymentUnit) throws DeploymentException {
        if (!this.isJavaEEApplication(deploymentUnit)) {
            return;
        }
        String appName = this.informer.getApplicationName(deploymentUnit);
        boolean isEnterpriseApplicationArchive = this.informer.isEnterpriseApplicationArchive(deploymentUnit);
        String name = "jboss.naming:application=" + appName;
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)name, (String)MCJavaEEApplication.class.getName()).addConstructorParameter(String.class.getName(), appName).addConstructorParameter(Boolean.TYPE.getName(), (Object)isEnterpriseApplicationArchive);
        builder.addPropertyMetaData("nameSpaces", builder.createInject((Object)"NameSpaces"));
        deploymentUnit.addAttachment(BeanMetaData.class + "." + name, (Object)builder.getBeanMetaData());
    }

    protected boolean isJavaEEApplication(DeploymentUnit deploymentUnit) {
        return this.informer.isJavaEEApplication(deploymentUnit);
    }
}

