/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.classloader;

import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloading.plugins.vfs.PackageVisitor;
import org.jboss.classloading.plugins.vfs.VFSResourceVisitor;
import org.jboss.classloading.spi.metadata.Capability;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaDataFactory;
import org.jboss.classloading.spi.metadata.ExportAll;
import org.jboss.classloading.spi.vfs.policy.VFSClassLoaderPolicy;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.deployers.plugins.classloading.AbstractDeploymentClassLoaderPolicyModule;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.plugins.classloader.VFSClassLoaderClassPathDeployer;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFSDeploymentClassLoaderPolicyModule
extends AbstractDeploymentClassLoaderPolicyModule {
    private static final long serialVersionUID = 1L;
    private static final VirtualFile[] NO_ROOTS = new VirtualFile[0];
    private VirtualFile[] vfsRoots;
    private VirtualFile[] excludedRoots;

    public VFSDeploymentClassLoaderPolicyModule(DeploymentUnit unit) {
        super(unit);
        List vfsClassPath = (List)unit.getAttachment(VFSClassLoaderClassPathDeployer.VFS_CLASS_PATH, List.class);
        this.vfsRoots = vfsClassPath == null ? NO_ROOTS : vfsClassPath.toArray(new VirtualFile[vfsClassPath.size()]);
        Set vfsExcludes = (Set)unit.getAttachment(VFSClassLoaderClassPathDeployer.VFS_EXCLUDES, Set.class);
        if (vfsExcludes != null) {
            this.excludedRoots = vfsExcludes.toArray(new VirtualFile[vfsExcludes.size()]);
        }
    }

    protected VirtualFile[] getRoots() {
        return this.vfsRoots != NO_ROOTS ? (VirtualFile[])this.vfsRoots.clone() : NO_ROOTS;
    }

    protected VirtualFile[] getExcludedRoots() {
        return this.excludedRoots != null ? (VirtualFile[])this.excludedRoots.clone() : null;
    }

    protected List<Capability> determineCapabilities() {
        VirtualFile[] roots = this.vfsRoots;
        CopyOnWriteArrayList<Capability> capabilities = super.determineCapabilities();
        if (capabilities != null) {
            return capabilities;
        }
        ClassLoadingMetaDataFactory factory = ClassLoadingMetaDataFactory.getInstance();
        capabilities = new CopyOnWriteArrayList<Capability>();
        Object version = this.getVersion();
        Capability capability = factory.createModule(this.getName(), version);
        capabilities.add(capability);
        ClassFilter included = this.getIncluded();
        ClassFilter excluded = this.getExcluded();
        ClassFilter excludedExport = this.getExcludedExport();
        ExportAll exportAll = this.getExportAll();
        if (exportAll != null) {
            Set exportedPackages = PackageVisitor.determineAllPackages((VirtualFile[])roots, (VirtualFile[])this.excludedRoots, (ExportAll)exportAll, (ClassFilter)included, (ClassFilter)excluded, (ClassFilter)excludedExport);
            for (String packageName : exportedPackages) {
                capability = factory.createPackage(packageName, version);
                capabilities.add(capability);
            }
        }
        return capabilities;
    }

    public VFSClassLoaderPolicy getPolicy() {
        return (VFSClassLoaderPolicy)super.getPolicy();
    }

    protected VFSClassLoaderPolicy determinePolicy() {
        VFSClassLoaderPolicy policy = VFSClassLoaderPolicy.createVFSClassLoaderPolicy((String)this.getContextName(), (VirtualFile[])this.vfsRoots, (VirtualFile[])this.excludedRoots);
        String[] packageNames = this.getPackageNames();
        policy.setExportedPackages(packageNames);
        policy.setIncluded(this.getIncluded());
        policy.setExcluded(this.getExcluded());
        policy.setExcludedExport(this.getExcludedExport());
        policy.setExportAll(this.getExportAll());
        policy.setImportAll(this.isImportAll());
        policy.setCacheable(this.isCacheable());
        policy.setBlackListable(this.isBlackListable());
        policy.setDelegates(this.getDelegates());
        return policy;
    }

    public URL getDynamicClassRoot() {
        return (URL)this.getDeploymentUnit().getAttachment("DYNAMIC_CLASS_URL_KEY", URL.class);
    }

    public void visit(ResourceVisitor visitor, ResourceFilter filter, ResourceFilter recurseFilter, URL ... urls) {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            throw new IllegalStateException("ClassLoader has not been constructed for " + this.getContextName());
        }
        VirtualFile[] roots = this.vfsRoots;
        if (roots != null && roots.length > 0) {
            ClassFilter included = this.getIncluded();
            ClassFilter excluded = this.getExcluded();
            VFSResourceVisitor.visit((VirtualFile[])roots, (VirtualFile[])this.excludedRoots, (ClassFilter)included, (ClassFilter)excluded, (ClassLoader)classLoader, (ResourceVisitor)visitor, (ResourceFilter)filter, (ResourceFilter)recurseFilter, (URL[])urls);
        }
    }
}

