/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.profileservice.profile.NoopProfile;
import org.jboss.profileservice.profile.metadata.domain.RequiredProfiles;
import org.jboss.profileservice.profile.metadata.plugin.EmptyProfileMetaData;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileFactory;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;

public class TypedProfileFactory
implements ProfileFactory<ProfileMetaData, Profile> {
    private static final Set<String> TYPES = new HashSet<String>();
    private Map<String, ProfileFactory<ProfileMetaData, Profile>> factories = new ConcurrentHashMap<String, ProfileFactory<ProfileMetaData, Profile>>();

    public String[] getTypes() {
        return TYPES.toArray(new String[TYPES.size()]);
    }

    public Profile createProfile(ProfileKey key, ProfileMetaData metaData) throws Exception {
        if (key == null) {
            throw new IllegalArgumentException("Null profile key.");
        }
        if (metaData == null) {
            throw new IllegalArgumentException("Null profile meta data");
        }
        String profileType = metaData.getClass().getName();
        if (TYPES.contains(profileType)) {
            return this.createNoopProfile(key, metaData);
        }
        return this.delegateCreate(profileType, key, metaData);
    }

    public void destroyProfile(ProfileMetaData metaData, Profile profile) {
        String profileType = metaData.getClass().getName();
        if (TYPES.contains(profileType)) {
            return;
        }
        ProfileFactory<ProfileMetaData, Profile> factory = this.factories.get(profileType);
        if (factory != null && factory != this) {
            factory.destroyProfile(metaData, profile);
        }
    }

    protected Profile delegateCreate(String profileType, ProfileKey key, ProfileMetaData metaData) throws Exception {
        ProfileFactory<ProfileMetaData, Profile> factory = this.factories.get(profileType);
        if (factory == null) {
            throw new IllegalStateException("Unrecognized meta data type: " + profileType);
        }
        return factory.createProfile(key, metaData);
    }

    protected Profile createNoopProfile(ProfileKey key, ProfileMetaData metaData) {
        return new NoopProfile(key);
    }

    public void addProfileFactory(ProfileFactory<ProfileMetaData, Profile> factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Null profile factory.");
        }
        if (factory.getTypes() == null) {
            throw new IllegalArgumentException("Null factory types.");
        }
        for (String type : factory.getTypes()) {
            this.addProfileFactory(type, factory);
        }
    }

    public void addProfileFactory(String type, ProfileFactory<ProfileMetaData, Profile> factory) {
        if (type == null) {
            throw new IllegalArgumentException("null factory type");
        }
        if (factory == null) {
            throw new IllegalArgumentException("null profile factory");
        }
        this.factories.put(type, factory);
    }

    public void removeProfileFactory(ProfileFactory<ProfileMetaData, Profile> factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Null profile factory.");
        }
        if (factory.getTypes() == null) {
            throw new IllegalArgumentException("Null factory types.");
        }
        for (String type : factory.getTypes()) {
            this.removeProfileFactory(type);
        }
    }

    public void removeProfileFactory(String type) {
        if (type == null) {
            throw new IllegalArgumentException("null factory type.");
        }
        this.factories.remove(type);
    }

    static {
        TYPES.add(EmptyProfileMetaData.class.getName());
        TYPES.add(RequiredProfiles.class.getName());
    }
}

