/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management;

import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.profileservice.spi.action.EventBus;
import org.jboss.profileservice.spi.action.ModificationEvent;
import org.jboss.profileservice.spi.action.ModificationListener;
import org.jboss.util.collection.ConcurrentSet;

public class AbstractEventBus
implements EventBus {
    private static final Logger log = Logger.getLogger(EventBus.class);
    private Set<ModificationListener> listeners = new ConcurrentSet();

    public void fireModificationEvent(ModificationEvent event) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (ModificationListener listener : this.listeners) {
                try {
                    listener.notify(event);
                }
                catch (Throwable t) {
                    log.debug((Object)("failed to notify listener: " + listener));
                }
            }
        }
    }

    public void addListener(ModificationListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ModificationListener listener) {
        this.listeners.remove(listener);
    }
}

