/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.repository.artifact;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.profileservice.spi.repository.artifact.Artifact;
import org.jboss.profileservice.spi.repository.artifact.ArtifactId;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepository;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepositoryId;
import org.jboss.vfs.VirtualFile;

public abstract class AbstractArtifact<T extends ArtifactId>
implements Artifact<T> {
    private final T identifier;
    private final ArtifactRepository<T> repository;

    public AbstractArtifact(T identifier, ArtifactRepository<T> repository) {
        if (identifier == null) {
            throw new IllegalArgumentException("null identifier");
        }
        if (repository == null) {
            throw new IllegalArgumentException("null repository");
        }
        this.identifier = identifier;
        this.repository = repository;
    }

    public T getIdentifier() {
        return this.identifier;
    }

    public long getLastModified() {
        try {
            return this.getFile().getLastModified();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public ArtifactRepositoryId getRepository() {
        return (ArtifactRepositoryId)this.repository.getIdentifier();
    }

    protected InputStream getInputStream() throws IOException {
        return this.getFile().openStream();
    }

    protected VirtualFile getFile() throws IOException {
        return this.repository.getArtifactFile(this.getIdentifier());
    }

    protected ArtifactRepository<T> getArtifactRepository() {
        return this.repository;
    }
}

