/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.virtual.assembly;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import org.jboss.profileservice.spi.virtual.assembly.VirtualDeploymentAssemblyContext;
import org.jboss.vfs.VFSUtils;

public abstract class AbstractVirtualAssemblyContext
implements Closeable {
    private final List<String> metaDataLocations = new ArrayList<String>();
    private final List<String> classPathLocations = new ArrayList<String>();
    private final List<VirtualDeploymentAssemblyContext> children = new ArrayList<VirtualDeploymentAssemblyContext>();

    public List<VirtualDeploymentAssemblyContext> getChildren() {
        return this.children;
    }

    public List<String> getMetaDataLocations() {
        return this.metaDataLocations;
    }

    protected void addMetaDataLocation(String path) {
        if (!this.metaDataLocations.contains(path)) {
            this.metaDataLocations.add(path);
        }
    }

    public List<String> getClassPathLocations() {
        return this.classPathLocations;
    }

    public void addClassPathLocation(String path) {
        this.classPathLocations.add(path);
    }

    protected void addChild(VirtualDeploymentAssemblyContext ctx) {
        if (ctx != null) {
            this.getChildren().add(ctx);
        }
    }

    @Override
    public void close() {
        for (VirtualDeploymentAssemblyContext ctx : this.children) {
            if (!(ctx instanceof Closeable)) continue;
            VFSUtils.safeClose((Closeable)((Closeable)Closeable.class.cast(ctx)));
        }
    }
}

