/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.metadata.deployers;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.deployers.Ejb3MetadataProcessingDeployer;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.jboss.jndi.resolver.impl.JNDIPolicyBasedJNDINameResolverFactory;
import org.jboss.metadata.ejb.jboss.jndi.resolver.spi.SessionBeanJNDINameResolver;
import org.jboss.metadata.ejb.jboss.jndipolicy.plugins.DefaultJNDIBindingPolicyFactory;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy;

public class JBossMetaDataResolvedJNDINameDeployer
extends AbstractDeployer {
    private static final Logger logger = Logger.getLogger(JBossMetaDataResolvedJNDINameDeployer.class);
    public static final String OUTPUT = JBossMetaDataResolvedJNDINameDeployer.class.getSimpleName();

    public JBossMetaDataResolvedJNDINameDeployer() {
        this.setStage(DeploymentStages.PRE_REAL);
        this.addInput(Ejb3MetadataProcessingDeployer.OUTPUT);
        this.addOutput(OUTPUT);
    }

    public void deploy(DeploymentUnit du) throws DeploymentException {
        JBossMetaData md = (JBossMetaData)du.getAttachment(Ejb3MetadataProcessingDeployer.OUTPUT, JBossMetaData.class);
        if (md == null) {
            return;
        }
        if (!md.isEJB3x()) {
            return;
        }
        logger.debug((Object)("Decorating EJB3 beans in unit " + du + " with JNDI Policy"));
        JBossEnterpriseBeansMetaData beans = md.getEnterpriseBeans();
        if (beans == null) {
            return;
        }
        DefaultJndiBindingPolicy jndiBindingPolicy = DefaultJNDIBindingPolicyFactory.getDefaultJNDIBindingPolicy();
        for (JBossEnterpriseBeanMetaData bean : beans) {
            String remoteHomeJNDIName;
            String localHomeJNDIName;
            String defaultBusinessLocalJNDIName;
            if (!bean.isSession() && !bean.isService()) continue;
            JBossSessionBeanMetaData sessionBean = (JBossSessionBeanMetaData)bean;
            SessionBeanJNDINameResolver sessionBeanJNDINameResolver = JNDIPolicyBasedJNDINameResolverFactory.getJNDINameResolver((JBossSessionBeanMetaData)sessionBean, (DefaultJndiBindingPolicy)jndiBindingPolicy);
            String defaultBusinessRemoteJNDIName = sessionBeanJNDINameResolver.resolveRemoteBusinessDefaultJNDIName(sessionBean);
            if (defaultBusinessRemoteJNDIName != null) {
                sessionBean.setJndiName(defaultBusinessRemoteJNDIName);
            }
            if ((defaultBusinessLocalJNDIName = sessionBeanJNDINameResolver.resolveLocalBusinessDefaultJNDIName(sessionBean)) != null) {
                sessionBean.setLocalJndiName(defaultBusinessLocalJNDIName);
            }
            if ((localHomeJNDIName = sessionBeanJNDINameResolver.resolveLocalHomeJNDIName(sessionBean)) != null) {
                sessionBean.setLocalHomeJndiName(localHomeJNDIName);
            }
            if ((remoteHomeJNDIName = sessionBeanJNDINameResolver.resolveRemoteHomeJNDIName(sessionBean)) == null) continue;
            sessionBean.setHomeJndiName(remoteHomeJNDIName);
        }
        du.addAttachment(OUTPUT, (Object)true, Boolean.class);
    }
}

