/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jpa.deployers.switchboard;

import javax.persistence.PersistenceContextType;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.jpa.deployers.switchboard.PersistenceContextRefResource;
import org.jboss.jpa.resolvers.PersistenceUnitDependencyResolver;
import org.jboss.logging.Logger;
import org.jboss.switchboard.javaee.environment.PersistenceContextRefType;
import org.jboss.switchboard.mc.spi.MCBasedResourceProvider;
import org.jboss.switchboard.spi.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceContextResourceProvider
implements MCBasedResourceProvider<PersistenceContextRefType> {
    private static final Logger log = Logger.getLogger(PersistenceContextResourceProvider.class);
    private PersistenceUnitDependencyResolver persistenceUnitDependencyResolver;

    public PersistenceContextResourceProvider(PersistenceUnitDependencyResolver resolver) {
        this.persistenceUnitDependencyResolver = resolver;
    }

    public Resource provide(DeploymentUnit unit, PersistenceContextRefType pcRef) {
        DeploymentUnit dependentDU = unit;
        if (unit.isComponent()) {
            dependentDU = unit.getParent();
        }
        log.debug((Object)("Resolving PU supplier for: " + pcRef.getPersistenceUnitName() + " in unit " + dependentDU));
        String puSupplier = this.persistenceUnitDependencyResolver.resolvePersistenceUnitSupplier(dependentDU, pcRef.getPersistenceUnitName());
        boolean extendedPc = PersistenceContextType.EXTENDED.equals((Object)pcRef.getPersistenceContextType());
        log.debug((Object)("Resolved PU supplier: " + puSupplier + " for persistence-context-ref: " + pcRef.getName() + " in unit " + dependentDU + (extendedPc ? " (extended pc)" : "")));
        return new PersistenceContextRefResource(puSupplier, pcRef);
    }

    public Class<PersistenceContextRefType> getEnvironmentEntryType() {
        return PersistenceContextRefType.class;
    }
}

