/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.ScheduledDeliveryHandler;

public class ScheduledDeliveryHandlerImpl
implements ScheduledDeliveryHandler {
    private static final Logger log = Logger.getLogger(ScheduledDeliveryHandlerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private final ScheduledExecutorService scheduledExecutor;
    private final Map<Long, ScheduledDeliveryRunnable> scheduledRunnables = new LinkedHashMap<Long, ScheduledDeliveryRunnable>();

    public ScheduledDeliveryHandlerImpl(ScheduledExecutorService scheduledExecutor) {
        this.scheduledExecutor = scheduledExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkAndSchedule(MessageReference ref) {
        long deliveryTime = ref.getScheduledDeliveryTime();
        if (deliveryTime > System.currentTimeMillis() && this.scheduledExecutor != null) {
            if (trace) {
                log.trace("Scheduling delivery for " + ref + " to occur at " + deliveryTime);
            }
            ScheduledDeliveryRunnable runnable = new ScheduledDeliveryRunnable(ref);
            Map<Long, ScheduledDeliveryRunnable> map = this.scheduledRunnables;
            synchronized (map) {
                this.scheduledRunnables.put(ref.getMessage().getMessageID(), runnable);
            }
            this.scheduleDelivery(runnable, deliveryTime);
            return true;
        }
        return false;
    }

    @Override
    public int getScheduledCount() {
        return this.scheduledRunnables.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageReference> getScheduledReferences() {
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        Map<Long, ScheduledDeliveryRunnable> map = this.scheduledRunnables;
        synchronized (map) {
            for (ScheduledDeliveryRunnable scheduledRunnable : this.scheduledRunnables.values()) {
                refs.add(scheduledRunnable.getReference());
            }
        }
        return refs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageReference> cancel(Filter filter) {
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        Map<Long, ScheduledDeliveryRunnable> map = this.scheduledRunnables;
        synchronized (map) {
            LinkedHashMap<Long, ScheduledDeliveryRunnable> copy = new LinkedHashMap<Long, ScheduledDeliveryRunnable>(this.scheduledRunnables);
            for (ScheduledDeliveryRunnable runnable : copy.values()) {
                if (filter != null && !filter.match(runnable.getReference().getMessage())) continue;
                runnable.cancel();
                refs.add(runnable.getReference());
            }
            for (MessageReference ref : refs) {
                this.scheduledRunnables.remove(ref.getMessage().getMessageID());
            }
        }
        return refs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageReference removeReferenceWithID(long id) {
        Map<Long, ScheduledDeliveryRunnable> map = this.scheduledRunnables;
        synchronized (map) {
            ScheduledDeliveryRunnable runnable = this.scheduledRunnables.remove(id);
            if (runnable == null) {
                return null;
            }
            return runnable.getReference();
        }
    }

    private void scheduleDelivery(ScheduledDeliveryRunnable runnable, long deliveryTime) {
        long now = System.currentTimeMillis();
        long delay = deliveryTime - now;
        ScheduledFuture<?> future = this.scheduledExecutor.schedule(runnable, delay, TimeUnit.MILLISECONDS);
        runnable.setFuture(future);
    }

    private class ScheduledDeliveryRunnable
    implements Runnable {
        private final MessageReference ref;
        private volatile Future<?> future;
        private boolean cancelled;

        public ScheduledDeliveryRunnable(MessageReference ref) {
            this.ref = ref;
        }

        public synchronized void setFuture(Future<?> future) {
            if (this.cancelled) {
                future.cancel(false);
            } else {
                this.future = future;
            }
        }

        public synchronized void cancel() {
            if (this.future != null) {
                this.future.cancel(false);
            }
            this.cancelled = true;
        }

        public MessageReference getReference() {
            return this.ref;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (trace) {
                log.trace("Scheduled delivery timeout " + this.ref);
            }
            Map map = ScheduledDeliveryHandlerImpl.this.scheduledRunnables;
            synchronized (map) {
                Object removed = ScheduledDeliveryHandlerImpl.this.scheduledRunnables.remove(this.ref.getMessage().getMessageID());
                if (removed == null) {
                    log.warn("Failed to remove timeout " + this);
                    return;
                }
            }
            this.ref.setScheduledDeliveryTime(0L);
            this.ref.getQueue().addFirst(this.ref);
        }
    }
}

