/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository.clustered.sync;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import java.util.TreeSet;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryContentMetadata;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryItemMetadata;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryRootMetadata;
import org.jboss.system.server.profileservice.repository.clustered.sync.ContentModification;
import org.jboss.system.server.profileservice.repository.clustered.sync.InconsistentRepositoryStructureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContentModificationGenerator {
    public List<ContentModification> getModificationList(RepositoryContentMetadata base, RepositoryContentMetadata modified) throws InconsistentRepositoryStructureException {
        if (base == null) {
            throw new IllegalArgumentException("Null base");
        }
        if (modified == null) {
            throw new IllegalArgumentException("Null modified");
        }
        Collection<RepositoryRootMetadata> baseRoots = base.getRepositories();
        Collection<RepositoryRootMetadata> modifiedRoots = modified.getRepositories();
        if (baseRoots.size() != modifiedRoots.size()) {
            throw new InconsistentRepositoryStructureException(base, modified);
        }
        ArrayList<ContentModification> mods = new ArrayList<ContentModification>();
        for (RepositoryRootMetadata root : base.getRepositories()) {
            RepositoryRootMetadata newRoot = modified.getRepositoryRootMetadata(root.getName());
            if (newRoot != null) {
                mods.addAll(this.getModificationList(root, newRoot));
                continue;
            }
            throw new InconsistentRepositoryStructureException(base, modified);
        }
        return mods;
    }

    protected abstract void handleAddition(String var1, RepositoryItemMetadata var2, GeneratedModifications var3);

    protected abstract void handleMissing(String var1, RepositoryItemMetadata var2, GeneratedModifications var3);

    protected void handleMatch(String rootName, RepositoryItemMetadata base, RepositoryItemMetadata modified, GeneratedModifications mods) {
        if (!base.equals(modified)) {
            if (base.isRemoved() && !modified.isRemoved()) {
                this.handleAddition(rootName, modified, base, mods);
            } else if (modified.isRemoved() && !base.isRemoved()) {
                this.handleRemoval(rootName, base, mods);
            } else if (base.isDirectory() && !modified.isDirectory()) {
                this.handleChangeFromDirectory(rootName, base, modified, mods);
            } else if (modified.isDirectory() && !base.isDirectory()) {
                this.handleChangeToDirectory(rootName, base, modified, mods);
            } else if (modified.isDirectory()) {
                this.handleDirectoryTimestampModification(rootName, base, modified, mods);
            } else {
                this.handleSimpleModification(rootName, base, modified, mods);
            }
        }
    }

    protected abstract void handleSimpleModification(String var1, RepositoryItemMetadata var2, RepositoryItemMetadata var3, GeneratedModifications var4);

    protected abstract void handleDirectoryTimestampModification(String var1, RepositoryItemMetadata var2, RepositoryItemMetadata var3, GeneratedModifications var4);

    protected abstract void handleChangeToDirectory(String var1, RepositoryItemMetadata var2, RepositoryItemMetadata var3, GeneratedModifications var4);

    protected abstract void handleChangeFromDirectory(String var1, RepositoryItemMetadata var2, RepositoryItemMetadata var3, GeneratedModifications var4);

    protected abstract void handleRemoval(String var1, RepositoryItemMetadata var2, GeneratedModifications var3);

    protected abstract void handleAddition(String var1, RepositoryItemMetadata var2, RepositoryItemMetadata var3, GeneratedModifications var4);

    protected void drainPreapprovedRemovals(GeneratedModifications mods) {
        ContentModification preapprovedRemoval;
        while ((preapprovedRemoval = mods.popPreapprovedRemoveParent()) != null) {
            mods.addModification(preapprovedRemoval);
        }
    }

    protected static RepositoryItemMetadata getMarkedRemovedItem(RepositoryItemMetadata base) {
        RepositoryItemMetadata result = base;
        if (!result.isRemoved()) {
            result = new RepositoryItemMetadata(result);
            result.setRemoved(true);
        }
        return result;
    }

    private List<ContentModification> getModificationList(RepositoryRootMetadata base, RepositoryRootMetadata modified) {
        ArrayList<ContentModification> mods = new ArrayList<ContentModification>();
        OwnedItem[] items = this.getOwnedItems(base, modified);
        RepositoryItemMetadata preapprovedAddParent = null;
        Stack<ContentModification> preapprovedRemoveParent = new Stack<ContentModification>();
        Stack<ContentModification> prerejectedAddParent = new Stack<ContentModification>();
        RepositoryItemMetadata prerejectedRemoveParent = null;
        for (int first = 0; first < items.length; ++first) {
            GeneratedModifications pairmod = new GeneratedModifications(preapprovedAddParent, preapprovedRemoveParent, prerejectedAddParent, prerejectedRemoveParent);
            int next = first + 1;
            if (next >= items.length) {
                if (items[first].base) {
                    this.handleMissing(base.getName(), items[first].item, pairmod);
                } else {
                    this.handleAddition(base.getName(), items[first].item, pairmod);
                }
            } else if (((Object)items[first].itemPath).equals(items[next].itemPath)) {
                this.handleMatch(base.getName(), items[first].item, items[next].item, pairmod);
                ++first;
            } else if (items[first].base) {
                this.handleMissing(base.getName(), items[first].item, pairmod);
            } else {
                this.handleAddition(base.getName(), items[first].item, pairmod);
            }
            mods.addAll(pairmod.getModifications());
            preapprovedAddParent = pairmod.getPreapprovedAddParent();
            prerejectedRemoveParent = pairmod.getPrerejectedRemoveParent();
        }
        for (ContentModification mod : preapprovedRemoveParent) {
            mods.add(mod);
        }
        for (ContentModification mod : prerejectedAddParent) {
            mods.add(mod);
        }
        return mods;
    }

    private OwnedItem[] getOwnedItems(RepositoryRootMetadata base, RepositoryRootMetadata modified) {
        TreeSet<OwnedItem> ownedItems = new TreeSet<OwnedItem>();
        for (RepositoryItemMetadata item : base.getContent()) {
            ownedItems.add(new OwnedItem(item, true));
        }
        for (RepositoryItemMetadata item : modified.getContent()) {
            ownedItems.add(new OwnedItem(item, false));
        }
        OwnedItem[] ownedItemArray = ownedItems.toArray(new OwnedItem[ownedItems.size()]);
        return ownedItemArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OwnedItem
    implements Comparable<OwnedItem> {
        public final boolean base;
        public final RepositoryItemMetadata item;
        public final List<String> itemPath;

        private OwnedItem(RepositoryItemMetadata item, boolean base) {
            assert (item != null) : "item is null";
            this.item = item;
            this.itemPath = item.getRelativePathElements();
            this.base = base;
        }

        @Override
        public int compareTo(OwnedItem other) {
            List<String> ourPath = this.itemPath;
            List<String> otherPath = other.itemPath;
            int result = 0;
            for (int i = 0; i < ourPath.size(); ++i) {
                if (i >= otherPath.size()) {
                    result = 1;
                    break;
                }
                int comp = ourPath.get(i).compareTo(otherPath.get(i));
                if (comp == 0) continue;
                result = comp < 0 ? -1 : 1;
                break;
            }
            if (result == 0 && otherPath.size() != ourPath.size()) {
                result = -1;
            }
            if (result == 0) {
                if (this.base && !other.base) {
                    result = -1;
                } else if (other.base && !this.base) {
                    result = 1;
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class GeneratedModifications {
        private RepositoryItemMetadata preapprovedAddParent;
        private final Stack<ContentModification> preapprovedRemoveParent;
        private final Stack<ContentModification> prerejectedAddParent;
        private RepositoryItemMetadata prerejectedRemoveParent;
        private final List<ContentModification> modifications = new ArrayList<ContentModification>();

        public GeneratedModifications(RepositoryItemMetadata preapprovedAddParent, Stack<ContentModification> preapprovedRemoveParent, Stack<ContentModification> prerejectedAddParent, RepositoryItemMetadata prerejectedRemoveParent) {
            if (preapprovedRemoveParent == null) {
                throw new IllegalArgumentException("Null preapprovedRemoveParent");
            }
            if (prerejectedAddParent == null) {
                throw new IllegalArgumentException("Null prerejectedAddParent");
            }
            this.preapprovedAddParent = preapprovedAddParent;
            this.preapprovedRemoveParent = preapprovedRemoveParent;
            this.prerejectedAddParent = prerejectedAddParent;
            this.prerejectedRemoveParent = prerejectedRemoveParent;
        }

        public void addModification(ContentModification mod) {
            this.modifications.add(mod);
        }

        public List<ContentModification> getModifications() {
            return this.modifications;
        }

        public RepositoryItemMetadata getPreapprovedAddParent() {
            return this.preapprovedAddParent;
        }

        public void setPreapprovedAddParent(RepositoryItemMetadata preapprovedAddParent) {
            if (preapprovedAddParent != null) {
                this.validateCanCallSet();
            }
            this.preapprovedAddParent = preapprovedAddParent;
        }

        public ContentModification peekPreapprovedRemoveParent() {
            return this.preapprovedRemoveParent.size() == 0 ? null : this.preapprovedRemoveParent.peek();
        }

        public ContentModification popPreapprovedRemoveParent() {
            return this.preapprovedRemoveParent.size() == 0 ? null : this.preapprovedRemoveParent.pop();
        }

        public void pushPreapprovedRemoveParent(ContentModification toPush) {
            if (toPush == null) {
                throw new IllegalArgumentException("Null prerejectedAddParent");
            }
            if (this.preapprovedAddParent != null) {
                throw new IllegalStateException("preapprovedAddParent already set");
            }
            if (this.prerejectedAddParent.size() > 0) {
                throw new IllegalStateException("prerejectedAddParent already set");
            }
            ContentModification peeked = this.peekPreapprovedRemoveParent();
            if (peeked != null && !toPush.getItem().isChildOf(peeked.getItem())) {
                throw new IllegalArgumentException(toPush.getItem() + " is not a child of existing item " + peeked.getItem());
            }
            this.preapprovedRemoveParent.push(toPush);
        }

        public ContentModification peekPrerejectedAddParent() {
            return this.prerejectedAddParent.size() == 0 ? null : this.prerejectedAddParent.peek();
        }

        public ContentModification popPrerejectedAddParent() {
            return this.prerejectedAddParent.size() == 0 ? null : this.prerejectedAddParent.pop();
        }

        public void pushPrerejectedAddParent(ContentModification toPush) {
            if (toPush == null) {
                throw new IllegalArgumentException("Null prerejectedAddParent");
            }
            if (this.preapprovedAddParent != null) {
                throw new IllegalStateException("preapprovedAddParent already set");
            }
            if (this.preapprovedRemoveParent.size() > 0) {
                throw new IllegalStateException("preapprovedRemoveParent already set");
            }
            if (this.prerejectedRemoveParent != null) {
                throw new IllegalStateException("prerejectedRemoveParent already set");
            }
            ContentModification peeked = this.peekPrerejectedAddParent();
            if (peeked != null && !toPush.getItem().isChildOf(peeked.getItem())) {
                throw new IllegalArgumentException(toPush.getItem() + " is not a child of existing item " + peeked.getItem());
            }
            this.prerejectedAddParent.push(toPush);
        }

        public RepositoryItemMetadata getPrerejectedRemoveParent() {
            return this.prerejectedRemoveParent;
        }

        public void setPrerejectedRemoveParent(RepositoryItemMetadata prerejectedRemoveParent) {
            if (prerejectedRemoveParent != null) {
                this.validateCanCallSet();
            }
            this.prerejectedRemoveParent = prerejectedRemoveParent;
        }

        private void validateCanCallSet() {
            if (this.preapprovedAddParent != null) {
                throw new IllegalStateException("preapprovedAddParent already set");
            }
            if (this.preapprovedRemoveParent.size() > 0) {
                throw new IllegalStateException("preapprovedRemoveParent already set");
            }
            if (this.prerejectedAddParent.size() > 0) {
                throw new IllegalStateException("prerejectedAddParent already set");
            }
            if (this.prerejectedRemoveParent != null) {
                throw new IllegalStateException("prerejectedRemoveParent already set");
            }
        }
    }
}

