/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.plugins.visitor;

import java.util.Arrays;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;

public class FederatedResourceVisitor
implements ResourceVisitor {
    private ResourceVisitor[] visitors;
    private ResourceFilter[] filters;
    private ResourceFilter[] recurseFilters;
    private ResourceFilter filter;
    private ResourceFilter recurseFilter;
    private boolean[] recurseFlags;
    private boolean[] filterFlags;

    public FederatedResourceVisitor(ResourceVisitor[] visitors) {
        if (visitors == null || visitors.length == 0) {
            throw new IllegalArgumentException("Null or empty visitors: " + Arrays.toString(visitors));
        }
        this.visitors = visitors;
    }

    public FederatedResourceVisitor(ResourceVisitor[] visitors, ResourceFilter[] filters, ResourceFilter[] recurseFilters) {
        this(visitors);
        this.filters = filters;
        this.recurseFilters = recurseFilters;
    }

    public ResourceFilter getRecurseFilter() {
        if (this.recurseFilters == null || this.recurseFilters.length == 0) {
            return null;
        }
        if (this.recurseFilter == null) {
            this.recurseFlags = new boolean[this.recurseFilters.length];
            for (int i = 0; i < this.recurseFlags.length; ++i) {
                this.recurseFlags[i] = true;
            }
            this.recurseFilter = new FederatedRecurseFilter();
        }
        return this.recurseFilter;
    }

    public ResourceFilter getFilter() {
        if (this.filters != null && this.filters.length == 0) {
            return null;
        }
        if (this.filter == null) {
            if (this.filters == null) {
                this.filters = new ResourceFilter[this.visitors.length];
                for (int i = 0; i < this.visitors.length; ++i) {
                    this.filters[i] = this.visitors[i].getFilter();
                }
            }
            this.filterFlags = new boolean[this.filters.length];
            this.filter = new FederatedResourceFilter();
        }
        return this.filter;
    }

    public void visit(ResourceContext resource) {
        for (int i = 0; i < this.visitors.length; ++i) {
            if (this.filterFlags != null && this.filterFlags.length > i && !this.filterFlags[i]) continue;
            this.visitors[i].visit(resource);
        }
    }

    private class FederatedResourceFilter
    implements ResourceFilter {
        private FederatedResourceFilter() {
        }

        public boolean accepts(ResourceContext resource) {
            boolean accept = false;
            for (int i = 0; i < FederatedResourceVisitor.this.filters.length; ++i) {
                if (FederatedResourceVisitor.this.recurseFlags == null || FederatedResourceVisitor.this.recurseFlags.length <= i || FederatedResourceVisitor.this.recurseFlags[i]) {
                    boolean bl = ((FederatedResourceVisitor)FederatedResourceVisitor.this).filterFlags[i] = FederatedResourceVisitor.this.filters[i] == null || FederatedResourceVisitor.this.filters[i].accepts(resource);
                    if (!FederatedResourceVisitor.this.filterFlags[i]) continue;
                    accept = true;
                    continue;
                }
                ((FederatedResourceVisitor)FederatedResourceVisitor.this).filterFlags[i] = false;
            }
            return accept;
        }
    }

    private class FederatedRecurseFilter
    implements ResourceFilter {
        private FederatedRecurseFilter() {
        }

        public boolean accepts(ResourceContext resource) {
            boolean accept = false;
            for (int i = 0; i < FederatedResourceVisitor.this.recurseFilters.length; ++i) {
                boolean bl = ((FederatedResourceVisitor)FederatedResourceVisitor.this).recurseFlags[i] = FederatedResourceVisitor.this.recurseFilters[i] == null || FederatedResourceVisitor.this.recurseFilters[i].accepts(resource);
                if (!FederatedResourceVisitor.this.recurseFlags[i]) continue;
                accept = true;
            }
            return accept;
        }
    }
}

