/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.bean.mc.deployer;

import java.util.Collection;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.plugins.builder.BeanMetaDataBuilderFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.managed.bean.mc.JNDIBinder;
import org.jboss.managed.bean.mc.util.ManagedBeanMCBeanUtil;
import org.jboss.managed.bean.metadata.ManagedBeanDeploymentMetaData;
import org.jboss.managed.bean.metadata.ManagedBeanMetaData;
import org.jboss.managed.bean.proxy.impl.ManagedBeanClassRefAddr;
import org.jboss.managed.bean.proxy.impl.ManagedBeanManagerRegistryRefAddr;
import org.jboss.managed.bean.proxy.impl.ManagedBeanProxyObjectFactory;
import org.jboss.managed.bean.spi.ManagedBeanManagerRegistry;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEComponentInformer;

public class ManagedBeanNamingDeployer
extends AbstractDeployer {
    private JavaEEComponentInformer javaeeComponentInformer;
    private ManagedBeanManagerRegistry managedBeanManagerRegistry;

    public ManagedBeanNamingDeployer() {
        this.setStage(DeploymentStages.REAL);
        this.setInput(ManagedBeanDeploymentMetaData.class);
        this.setOutput(BeanMetaData.class);
    }

    @Inject
    public void setManagedBeanManagerRegistry(ManagedBeanManagerRegistry registry) {
        this.managedBeanManagerRegistry = registry;
    }

    @Inject
    public void setJavaEEComponentInformer(JavaEEComponentInformer componentInformer) {
        this.javaeeComponentInformer = componentInformer;
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        ManagedBeanDeploymentMetaData managedBeanDeployment = (ManagedBeanDeploymentMetaData)unit.getAttachment(ManagedBeanDeploymentMetaData.class);
        Collection managedBeans = managedBeanDeployment.getManagedBeans();
        if (managedBeans == null || managedBeans.isEmpty()) {
            return;
        }
        for (ManagedBeanMetaData managedBean : managedBeans) {
            this.deploy(unit, managedBean);
        }
    }

    private void deploy(DeploymentUnit unit, ManagedBeanMetaData managedBean) throws DeploymentException {
        String managedBeanManagerName = ManagedBeanMCBeanUtil.getManagedBeanManagerMCBeanName(this.javaeeComponentInformer, unit, managedBean);
        Reference reference = new Reference("Object Factory for managed bean", ManagedBeanProxyObjectFactory.class.getName(), null);
        StringRefAddr managerNameRefAddr = new StringRefAddr("ManagedBeanManagerNameRefAddr", managedBeanManagerName);
        reference.add(managerNameRefAddr);
        ManagedBeanClassRefAddr managedBeanClassRefAddr = new ManagedBeanClassRefAddr(this.getManagedBeanClass(unit.getClassLoader(), managedBean));
        reference.add((RefAddr)managedBeanClassRefAddr);
        ManagedBeanManagerRegistryRefAddr managedBeanManagerRegistryRefAddr = new ManagedBeanManagerRegistryRefAddr(this.managedBeanManagerRegistry);
        reference.add((RefAddr)managedBeanManagerRegistryRefAddr);
        String moduleName = this.javaeeComponentInformer.getModuleName(unit);
        String javaAppNamespaceJNDIName = moduleName + "/" + managedBean.getName();
        JNDIBinder javaAppJNDIBinder = new JNDIBinder(javaAppNamespaceJNDIName, reference, true);
        String javaAppJNDIBinderName = ManagedBeanMCBeanUtil.getJNDIBinderMCBeanPrefix(unit) + ",jndiname=java:app/" + javaAppNamespaceJNDIName;
        BeanMetaDataBuilder javaAppJNDIBinderBuilder = BeanMetaDataBuilderFactory.createBuilder((String)javaAppJNDIBinderName, (String)JNDIBinder.class.getName());
        javaAppJNDIBinderBuilder.setConstructorValue((Object)javaAppJNDIBinder);
        AbstractInjectionValueMetaData javaeeModuleInjectMetaData = new AbstractInjectionValueMetaData((Object)this.getJavaEEModuleMCBeanName(unit));
        javaAppJNDIBinderBuilder.addPropertyMetaData("javaEEModule", (ValueMetaData)javaeeModuleInjectMetaData);
        unit.addAttachment(BeanMetaData.class + ":" + javaAppJNDIBinderName, (Object)javaAppJNDIBinderBuilder.getBeanMetaData(), BeanMetaData.class);
        String javaModuleNamespaceJNDIName = managedBean.getName();
        JNDIBinder javaModuleJNDIBinder = new JNDIBinder(javaModuleNamespaceJNDIName, reference, false);
        String javaModuleJNDIBinderName = ManagedBeanMCBeanUtil.getJNDIBinderMCBeanPrefix(unit) + ",jndiname=java:module/" + javaModuleNamespaceJNDIName;
        BeanMetaDataBuilder javaModuleJNDIBinderBuilder = BeanMetaDataBuilderFactory.createBuilder((String)javaModuleJNDIBinderName, (String)JNDIBinder.class.getName());
        javaModuleJNDIBinderBuilder.setConstructorValue((Object)javaModuleJNDIBinder);
        javaModuleJNDIBinderBuilder.addPropertyMetaData("javaEEModule", (ValueMetaData)javaeeModuleInjectMetaData);
        unit.addAttachment(BeanMetaData.class + ":" + javaModuleJNDIBinderName, (Object)javaModuleJNDIBinderBuilder.getBeanMetaData(), BeanMetaData.class);
    }

    private String getJavaEEModuleMCBeanName(DeploymentUnit deploymentUnit) {
        String applicationName = this.javaeeComponentInformer.getApplicationName(deploymentUnit);
        String moduleName = this.javaeeComponentInformer.getModuleName(deploymentUnit);
        StringBuilder builder = new StringBuilder("jboss.naming:");
        if (applicationName != null) {
            builder.append("application=").append(applicationName).append(",");
        }
        builder.append("module=").append(moduleName);
        return builder.toString();
    }

    private Class<?> getManagedBeanClass(ClassLoader cl, ManagedBeanMetaData managedBean) throws DeploymentException {
        String klass = managedBean.getManagedBeanClass();
        try {
            return cl.loadClass(klass);
        }
        catch (ClassNotFoundException cnfe) {
            throw new DeploymentException((Throwable)cnfe);
        }
    }
}

