/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hibernate.deployers.metadata;

import java.io.Serializable;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.hibernate.deployers.metadata.BaseElement;
import org.jboss.hibernate.deployers.metadata.BaseNamedElement;
import org.jboss.hibernate.jmx.Hibernate;
import org.jboss.util.id.GUID;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="session-factory")
@XmlType(name="sessionFactoryType", propOrder={"properties", "depends"})
public class SessionFactoryMetaData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String bean;
    private Set<BaseNamedElement> properties;
    private Set<BaseElement> depends;

    @XmlTransient
    protected String getBeanName() {
        return this.bean != null ? this.bean : GUID.asString() + "$Hibernate";
    }

    @XmlTransient
    public BeanMetaData getBeanMetaData() {
        return this.getBeanMetaData(null);
    }

    public BeanMetaData getBeanMetaData(VirtualFile root) {
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)this.getBeanName(), (String)Hibernate.class.getName());
        if (root != null) {
            builder.addConstructorParameter(VirtualFile.class.getName(), (Object)root);
        }
        builder.addPropertyMetaData("sessionFactoryName", this.getName());
        if (this.properties != null && !this.properties.isEmpty()) {
            builder.addPropertyMetaData("configurationElements", this.properties);
        }
        if (this.depends != null && !this.depends.isEmpty()) {
            for (BaseElement bne : this.depends) {
                builder.addDependency(bne.getValue());
            }
        }
        return builder.getBeanMetaData();
    }

    public String getName() {
        return this.name;
    }

    @XmlAttribute(required=true)
    public void setName(String name) {
        this.name = name;
    }

    public String getBean() {
        return this.bean;
    }

    @XmlAttribute
    public void setBean(String bean) {
        this.bean = bean;
    }

    public Set<BaseNamedElement> getProperties() {
        return this.properties;
    }

    @XmlElement(name="property")
    public void setProperties(Set<BaseNamedElement> properties) {
        this.properties = properties;
    }

    public Set<BaseElement> getDepends() {
        return this.depends;
    }

    @XmlElement(name="depends")
    public void setDepends(Set<BaseElement> depends) {
        this.depends = depends;
    }
}

