/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jmx;

import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Set;
import org.mc4j.ems.connection.bean.EmsBean;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jmx.MBeanResourceComponent;

public class ThreadDataMeasurementComponent
extends MBeanResourceComponent {
    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        if ("threadDump".equals(name)) {
            ThreadMXBean threadBean = (ThreadMXBean)this.getEmsBean().getProxy(ThreadMXBean.class);
            long[] threadIds = threadBean.getAllThreadIds();
            ThreadInfo[] threadInfos = threadBean.getThreadInfo(threadIds, Integer.MAX_VALUE);
            OperationResult result = new OperationResult();
            Configuration resultConfig = result.getComplexResults();
            resultConfig.put((Property)new PropertySimple("totalCount", (Object)threadBean.getThreadCount()));
            PropertyList threadList = new PropertyList("threadList");
            resultConfig.put((Property)threadList);
            for (ThreadInfo threadInfo : threadInfos) {
                PropertyMap map = new PropertyMap("thread");
                map.put((Property)new PropertySimple("name", (Object)threadInfo.getThreadName()));
                map.put((Property)new PropertySimple("id", (Object)threadInfo.getThreadId()));
                map.put((Property)new PropertySimple("state", (Object)threadInfo.getThreadState().name()));
                map.put((Property)new PropertySimple("stack", (Object)this.getStringStackTrace(threadInfo.getStackTrace())));
                threadList.add((Property)map);
            }
            return result;
        }
        return super.invokeOperation(name, parameters);
    }

    protected void getValues(MeasurementReport report, Set requests, EmsBean bean) {
        super.getValues(report, requests, bean);
        for (MeasurementScheduleRequest request : requests) {
            try {
                if (request.getName().equals("SuspendedThreadCount")) {
                    log.debug((Object)"Getting suspended threads count value...");
                    report.addData(new MeasurementDataNumeric(request, this.getSuspendedThreadsCount(bean)));
                    continue;
                }
                if (!request.getName().equals("DeadLockedThreadCount")) continue;
                log.debug((Object)"Getting deadlocked threads count value...");
                report.addData(new MeasurementDataNumeric(request, this.getDeadLockedThreadsCount(bean)));
            }
            catch (Exception e) {
                log.error((Object)("Failed to obtain measurement [" + request.getName() + "]. Cause: " + e.getMessage()));
            }
        }
    }

    private String getStringStackTrace(StackTraceElement[] st) {
        StringBuilder buf = new StringBuilder(2000);
        for (StackTraceElement e : st) {
            buf.append(e.getClassName());
            buf.append(".");
            buf.append(e.getMethodName());
            buf.append("(");
            buf.append(e.getFileName());
            buf.append(":");
            buf.append(e.getLineNumber());
            buf.append(")\n");
        }
        if (buf.length() > 2000) {
            return buf.substring(0, 2000);
        }
        return buf.toString();
    }

    private Double getSuspendedThreadsCount(EmsBean bean) {
        ThreadInfo[] tinfos;
        Double res = 0.0;
        ThreadMXBean threadBean = (ThreadMXBean)bean.getProxy(ThreadMXBean.class);
        long[] tids = threadBean.getAllThreadIds();
        for (ThreadInfo ti : tinfos = threadBean.getThreadInfo(tids, Integer.MAX_VALUE)) {
            if (ti == null || !ti.isSuspended()) continue;
            Double d = res;
            Double d2 = res = Double.valueOf(res + 1.0);
        }
        return res;
    }

    private Double getDeadLockedThreadsCount(EmsBean bean) {
        ThreadMXBean threadBean = (ThreadMXBean)bean.getProxy(ThreadMXBean.class);
        long[] tids = threadBean.findMonitorDeadlockedThreads();
        if (tids == null) {
            return 0.0;
        }
        return new Double(tids.length);
    }
}

