/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.embedded.impl.base;

import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.ejb.embeddable.EJBContainer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.bootstrap.api.mc.server.MCBasedServer;
import org.jboss.bootstrap.api.mc.server.MCServer;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
import org.jboss.ejb3.embedded.api.EJBDeploymentException;
import org.jboss.ejb3.embedded.impl.base.scanner.ClassPathEjbJarScanner;
import org.jboss.ejb3.embedded.spi.JBossEJBContainerProvider;
import org.jboss.kernel.Kernel;
import org.jboss.logging.Logger;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public abstract class JBossEJBContainerBase
extends EJBContainer
implements JBossEJBContainerProvider {
    private static final Logger log = Logger.getLogger(JBossEJBContainerBase.class);
    private final MainDeployer deployer;
    private final MCBasedServer<?, ?> mcServer;
    private final Map<URL, Deployment> deployments;

    protected JBossEJBContainerBase(Map<?, ?> properties, MCBasedServer<?, ?> server, String[] modules) {
        if (server == null) {
            throw new IllegalArgumentException("MC Server must be specified");
        }
        Kernel kernel = server.getKernel();
        MainDeployer mainDeployer = (MainDeployer)kernel.getController().getContextByClass(MainDeployer.class).getTarget();
        assert (mainDeployer != null) : "MainDeployer found in Kernel was null";
        log.info((Object)("Started JBoss Embedded " + EJBContainer.class.getSimpleName()));
        log.info((Object)("Modules for deployment: " + Arrays.asList(modules)));
        this.mcServer = server;
        this.deployer = mainDeployer;
        this.deployments = new HashMap<URL, Deployment>();
    }

    protected JBossEJBContainerBase(Map<?, ?> properties, MCServer server) {
        this(properties, (MCBasedServer<?, ?>)server, ClassPathEjbJarScanner.getEjbJars());
    }

    protected void deploy(Deployment ... deployments) throws EJBDeploymentException, IllegalArgumentException {
        if (deployments == null || deployments.length == 0) {
            throw new IllegalArgumentException("At least one deployment must be specified");
        }
        HashSet<Deployment> deploymentsAdded = new HashSet<Deployment>(deployments.length);
        for (Deployment deployment : deployments) {
            if (log.isTraceEnabled()) {
                log.tracef("Adding deployment: ", new Object[]{deployment});
            }
            try {
                this.deployer.addDeployment(deployment);
                deploymentsAdded.add(deployment);
            }
            catch (DeploymentException mainDeploymentException) {
                for (Deployment pending : deploymentsAdded) {
                    try {
                        this.deployer.removeDeployment(pending);
                    }
                    catch (DeploymentException pendingDeploymentRemovalException) {
                        log.warn((Object)("Could not back out pending deployment due to " + (Object)((Object)pendingDeploymentRemovalException) + " while handing deployment error: " + (Object)((Object)mainDeploymentException)));
                    }
                }
                throw EJBDeploymentException.newInstance((String)("Could not add deployment: " + deployment), (Throwable)mainDeploymentException);
            }
        }
        this.deployer.process();
        try {
            this.deployer.checkComplete();
        }
        catch (DeploymentException e) {
            throw EJBDeploymentException.newInstance((String)"Processing the pending deployments resulted in error", (Throwable)e);
        }
    }

    protected void undeploy(Deployment ... deployments) throws EJBDeploymentException, IllegalArgumentException {
        if (deployments == null || deployments.length == 0) {
            throw new IllegalArgumentException("At least one deployment must be specified");
        }
        for (Deployment deployment : deployments) {
            if (log.isTraceEnabled()) {
                log.tracef("Removing deployment: ", new Object[]{deployment});
            }
            try {
                this.deployer.removeDeployment(deployment);
            }
            catch (DeploymentException mainDeploymentException) {
                throw EJBDeploymentException.newInstance((String)("Could not remove deployment: " + deployment), (Throwable)mainDeploymentException);
            }
        }
        this.deployer.process();
        try {
            this.deployer.checkComplete();
        }
        catch (DeploymentException e) {
            throw EJBDeploymentException.newInstance((String)"Processing the removed deployments resulted in error", (Throwable)e);
        }
    }

    protected void deploy(URL ... urls) throws EJBDeploymentException, IllegalArgumentException {
        if (urls == null) {
            throw new IllegalArgumentException("URLs must be specified");
        }
        HashMap<URL, VFSDeployment> newDeployments = new HashMap<URL, VFSDeployment>(urls.length);
        for (int i = 0; i < urls.length; ++i) {
            VirtualFile root;
            URL url = urls[i];
            try {
                root = VFS.getChild((URL)url);
            }
            catch (URISyntaxException urise) {
                throw new RuntimeException("Could not create a virtual file to deploy from URL: " + url, urise);
            }
            VFSDeployment deployment = VFSDeploymentFactory.getInstance().createVFSDeployment(root);
            newDeployments.put(url, deployment);
        }
        this.deploy(newDeployments.values().toArray(new Deployment[0]));
        this.deployments.putAll(newDeployments);
    }

    protected void undeploy(URL ... urls) throws EJBDeploymentException, IllegalArgumentException {
        if (urls == null) {
            throw new IllegalArgumentException("URLs must be specified");
        }
        HashSet<Deployment> deploymentsToRemove = new HashSet<Deployment>();
        HashSet<URL> urlsToUnregister = new HashSet<URL>();
        for (URL url : urls) {
            Deployment deployment = this.deployments.get(url);
            if (deployment == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Ignoring undeployment request of " + url.toExternalForm() + "; has not been previously deployed via " + (Object)((Object)this)));
                continue;
            }
            deploymentsToRemove.add(deployment);
            urlsToUnregister.add(url);
        }
        this.undeploy(deploymentsToRemove.toArray(new Deployment[0]));
        for (URL url : urlsToUnregister) {
            this.deployments.remove(url);
        }
    }

    public MCBasedServer<?, ?> getMCServer() {
        return this.mcServer;
    }

    public Context getContext() {
        try {
            return new InitialContext();
        }
        catch (NamingException e) {
            throw new RuntimeException("Could not create new naming context", e);
        }
    }
}

