/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.Executor;
import org.jboss.xnio.nio.NioSelectorRunnable;
import org.jboss.xnio.nio.SelectorTask;

final class NioHandle {
    private final SelectionKey selectionKey;
    private final NioSelectorRunnable selectorRunnable;
    private final Runnable handler;
    private final Executor handlerExecutor;
    private final boolean oneshot;

    NioHandle(SelectionKey selectionKey, NioSelectorRunnable selectorRunnable, Runnable handler, Executor handlerExecutor, boolean oneshot) {
        this.selectionKey = selectionKey;
        this.selectorRunnable = selectorRunnable;
        this.handler = handler;
        this.handlerExecutor = handlerExecutor;
        this.oneshot = oneshot;
    }

    SelectionKey getSelectionKey() {
        return this.selectionKey;
    }

    NioSelectorRunnable getSelectorRunnable() {
        return this.selectorRunnable;
    }

    Runnable getHandler() {
        return this.handler;
    }

    Executor getHandlerExecutor() {
        return this.handlerExecutor;
    }

    void cancelKey() {
        this.selectorRunnable.runTask(new SelectorTask(){

            @Override
            public void run(Selector selector) {
                NioHandle.this.selectionKey.cancel();
            }
        });
    }

    void resume(int op) {
        this.selectionKey.interestOps(op);
        this.selectorRunnable.wakeup();
    }

    void suspend() {
        this.selectionKey.interestOps(0);
        this.selectorRunnable.wakeup();
    }

    boolean isOneshot() {
        return this.oneshot;
    }
}

