/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.agent.metadata;

import org.rhq.core.clientapi.agent.metadata.ConfigurationMetadataParser;
import org.rhq.core.clientapi.agent.metadata.InvalidPluginDescriptorException;
import org.rhq.core.clientapi.descriptor.configuration.ConfigurationDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.ContentDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.ContentDescriptorCategory;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.content.PackageCategory;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.util.StringUtils;

public class ContentMetadataParser {
    public static PackageType parseContentDescriptor(ContentDescriptor descriptor) throws InvalidPluginDescriptorException {
        PackageCategory category = ContentMetadataParser.translateCategory(descriptor.getCategory());
        PackageType type = new PackageType();
        type.setName(descriptor.getName());
        type.setDescription(descriptor.getDescription());
        type.setCategory(category);
        type.setSupportsArchitecture(descriptor.isSupportsArchitecture());
        String displayName = descriptor.getDisplayName();
        if (displayName == null || displayName.equals("")) {
            displayName = StringUtils.deCamelCase((String)descriptor.getName());
        }
        type.setDisplayName(displayName);
        type.setDiscoveryInterval((long)descriptor.getDiscoveryInterval());
        type.setCreationData(descriptor.isIsCreationType());
        ConfigurationDescriptor configurationDescriptor = descriptor.getConfiguration();
        ConfigurationDefinition configurationDefinition = ConfigurationMetadataParser.parse(descriptor.getName(), configurationDescriptor);
        type.setDeploymentConfigurationDefinition(configurationDefinition);
        return type;
    }

    private static PackageCategory translateCategory(ContentDescriptorCategory descriptorCategory) {
        PackageCategory category = null;
        switch (descriptorCategory) {
            case CONFIGURATION: {
                category = PackageCategory.CONFIGURATION;
                break;
            }
            case DEPLOYABLE: {
                category = PackageCategory.DEPLOYABLE;
                break;
            }
            case EXECUTABLE_BINARY: {
                category = PackageCategory.EXECUTABLE_BINARY;
                break;
            }
            case EXECUTABLE_SCRIPT: {
                category = PackageCategory.EXECUTABLE_SCRIPT;
            }
        }
        if (category == null) {
            throw new IllegalArgumentException("Descriptor category " + (Object)((Object)descriptorCategory) + " does not translate to domain model");
        }
        return category;
    }
}

