/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.env.bda;

import org.jboss.classloading.spi.RealClassLoader;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.deployers.plugins.classloading.AbstractDeploymentClassLoaderPolicyModule;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.weld.integration.deployer.env.bda.SecurityActions;
import org.jboss.weld.integration.deployer.env.bda.TopLevelClassLoaderGetter;

public class DUTopLevelClassLoaderGetter
implements TopLevelClassLoaderGetter {
    public static final TopLevelClassLoaderGetter INSTANCE = new DUTopLevelClassLoaderGetter();

    public static TopLevelClassLoaderGetter getInstance() {
        return INSTANCE;
    }

    public ClassLoader getTopLevelClassLoader(ClassLoader cl) {
        ClassLoader firstBaseClassLoader;
        if (cl == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        for (firstBaseClassLoader = cl; firstBaseClassLoader != null && !(firstBaseClassLoader instanceof RealClassLoader); firstBaseClassLoader = firstBaseClassLoader.getParent()) {
        }
        if (firstBaseClassLoader == null) {
            return cl;
        }
        Module module = SecurityActions.getModuleForClassLoader(firstBaseClassLoader);
        if (module == null || !(module instanceof AbstractDeploymentClassLoaderPolicyModule)) {
            return cl;
        }
        AbstractDeploymentClassLoaderPolicyModule abclm = (AbstractDeploymentClassLoaderPolicyModule)module;
        DeploymentUnit du = abclm.getDeploymentUnit();
        return du.getTopLevel().getClassLoader();
    }
}

