/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.env.bda;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.integration.deployer.env.bda.Archive;
import org.jboss.weld.integration.deployer.env.bda.ArchiveCollection;
import org.jboss.weld.integration.deployer.env.bda.Classpath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NoDuplicatesClasspath
extends ArchiveCollection
implements Classpath {
    private final String name;
    private BeanDeploymentArchive reference = null;
    private Collection<BeanDeploymentArchive> referenceCollection = new ArrayList<BeanDeploymentArchive>();
    private Classpath classpath;

    public NoDuplicatesClasspath(String name, Archive ... archives) {
        this.name = name;
        this.archives = new HashSet<Archive>();
        for (Archive archive : archives) {
            this.add(archive);
        }
    }

    public NoDuplicatesClasspath(String name, Classpath classpath, Archive ... archives) {
        this(name, archives);
        this.classpath = classpath;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addArchive(Archive archive) {
        this.add(archive);
    }

    @Override
    public Classpath getClasspath() {
        return this.classpath;
    }

    @Override
    public Collection<BeanDeploymentArchive> getBDAs(BeanDeploymentArchive bda) {
        if (this.reference == null && this.classpath != null) {
            return this.classpath.getBDAs(bda);
        }
        if (bda == this.reference) {
            Collection<BeanDeploymentArchive> otherBDAs = this.getBDAs();
            if (otherBDAs.isEmpty()) {
                if (this.classpath != null) {
                    return this.classpath.getBDAs(bda);
                }
                return Collections.emptyList();
            }
            ArrayList<BeanDeploymentArchive> allBDAs = new ArrayList<BeanDeploymentArchive>();
            allBDAs.addAll(otherBDAs);
            allBDAs.addAll(this.classpath.getBDAs(bda));
            return allBDAs;
        }
        return this.referenceCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void archiveVisible(Archive archive, BeanDeploymentArchive bda) {
        Collection collection = this.bdas;
        synchronized (collection) {
            if (this.reference == null) {
                this.reference = bda;
                this.referenceCollection.add(bda);
            } else {
                super.archiveVisible(archive, bda);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void archiveDestroyed(Archive archive) {
        BeanDeploymentArchive bda = archive.getBeanDeploymentArchive();
        if (bda != null) {
            Collection collection = this.bdas;
            synchronized (collection) {
                if (this.reference == bda) {
                    this.reference = null;
                    this.referenceCollection.clear();
                    if (!this.bdas.isEmpty()) {
                        Iterator iterator = this.bdas.iterator();
                        this.reference = (BeanDeploymentArchive)iterator.next();
                        iterator.remove();
                        this.referenceCollection.add(this.reference);
                    }
                    NoDuplicatesClasspath noDuplicatesClasspath = this;
                    synchronized (noDuplicatesClasspath) {
                        this.archives.remove(archive);
                    }
                } else {
                    super.archiveDestroyed(archive);
                }
            }
        }
    }

    public String toString() {
        return "Classpath[" + this.name + "]";
    }
}

