/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.ws.policy.Assertor;
import org.apache.cxf.ws.policy.EffectivePolicy;
import org.apache.cxf.ws.policy.EndpointPolicy;
import org.apache.cxf.ws.policy.EndpointPolicyImpl;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.PolicyEngineImpl;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.cxf.ws.policy.PolicyInterceptorProvider;
import org.apache.cxf.ws.policy.PolicyInterceptorProviderRegistry;
import org.apache.cxf.ws.policy.PolicyUtils;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EffectivePolicyImpl
implements EffectivePolicy {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(EffectivePolicyImpl.class);
    private static final Logger LOG = LogUtils.getL7dLogger(EffectivePolicyImpl.class);
    protected Policy policy;
    protected Collection<PolicyAssertion> chosenAlternative;
    protected List<Interceptor<? extends Message>> interceptors;

    public Policy getPolicy() {
        return this.policy;
    }

    public List<Interceptor<? extends Message>> getInterceptors() {
        return this.interceptors;
    }

    public Collection<PolicyAssertion> getChosenAlternative() {
        return this.chosenAlternative;
    }

    void initialise(EndpointPolicyImpl epi, PolicyEngineImpl engine, boolean inbound) {
        this.policy = epi.getPolicy();
        this.chosenAlternative = epi.getChosenAlternative();
        if (this.chosenAlternative == null) {
            this.chooseAlternative(engine, null);
        }
        this.initialiseInterceptors(engine, inbound);
    }

    void initialise(EndpointInfo ei, BindingOperationInfo boi, PolicyEngineImpl engine, Assertor assertor, boolean requestor, boolean request) {
        this.initialisePolicy(ei, boi, engine, requestor, request, assertor);
        this.chooseAlternative(engine, assertor);
        this.initialiseInterceptors(engine, false);
    }

    void initialise(EndpointInfo ei, BindingOperationInfo boi, PolicyEngineImpl engine, boolean requestor, boolean request) {
        Assertor assertor = this.initialisePolicy(ei, boi, engine, requestor, request, null);
        this.chooseAlternative(engine, assertor);
        this.initialiseInterceptors(engine, requestor);
    }

    void initialise(EndpointInfo ei, BindingFaultInfo bfi, PolicyEngineImpl engine, Assertor assertor) {
        this.initialisePolicy(ei, bfi, engine);
        this.chooseAlternative(engine, assertor);
        this.initialiseInterceptors(engine, false);
    }

    Assertor initialisePolicy(EndpointInfo ei, BindingOperationInfo boi, PolicyEngineImpl engine, boolean requestor, boolean request, Assertor assertor) {
        if (boi.isUnwrapped()) {
            boi = boi.getUnwrappedOperation();
        }
        BindingMessageInfo bmi = request ? boi.getInput() : boi.getOutput();
        EndpointPolicy ep = requestor ? engine.getClientEndpointPolicy(ei, (Conduit)assertor) : engine.getServerEndpointPolicy(ei, (Destination)assertor);
        this.policy = ep.getPolicy();
        if (ep instanceof EndpointPolicyImpl) {
            assertor = ((EndpointPolicyImpl)ep).getAssertor();
        }
        this.policy = this.policy.merge(engine.getAggregatedOperationPolicy(boi));
        if (null != bmi) {
            this.policy = this.policy.merge(engine.getAggregatedMessagePolicy(bmi));
        }
        this.policy = (Policy)this.policy.normalize(engine.getRegistry(), true);
        return assertor;
    }

    void initialisePolicy(EndpointInfo ei, BindingFaultInfo bfi, PolicyEngineImpl engine) {
        BindingOperationInfo boi = bfi.getBindingOperation();
        this.policy = engine.getServerEndpointPolicy(ei, null).getPolicy();
        this.policy = this.policy.merge(engine.getAggregatedOperationPolicy(boi));
        this.policy = this.policy.merge(engine.getAggregatedFaultPolicy(bfi));
        this.policy = (Policy)this.policy.normalize(engine.getRegistry(), true);
    }

    void chooseAlternative(PolicyEngineImpl engine, Assertor assertor) {
        Collection alternative = engine.getAlternativeSelector().selectAlternative(this.policy, (PolicyEngine)engine, assertor);
        if (null == alternative) {
            PolicyUtils.logPolicy(LOG, Level.FINE, "No alternative supported.", (PolicyComponent)this.getPolicy());
            throw new PolicyException(new org.apache.cxf.common.i18n.Message("NO_ALTERNATIVE_EXC", BUNDLE, new Object[0]));
        }
        this.setChosenAlternative(alternative);
    }

    void initialiseInterceptors(PolicyEngineImpl engine) {
        this.initialiseInterceptors(engine, false);
    }

    void initialiseInterceptors(PolicyEngineImpl engine, boolean useIn) {
        if (engine.getBus() != null) {
            PolicyInterceptorProviderRegistry reg = (PolicyInterceptorProviderRegistry)engine.getBus().getExtension(PolicyInterceptorProviderRegistry.class);
            LinkedHashSet<Interceptor<? extends Message>> out = new LinkedHashSet<Interceptor<? extends Message>>();
            for (PolicyAssertion a : this.getChosenAlternative()) {
                this.initialiseInterceptors(reg, engine, out, a, useIn);
            }
            this.setInterceptors(new ArrayList<Interceptor<? extends Message>>(out));
        }
    }

    protected Collection<PolicyAssertion> getSupportedAlternatives(PolicyEngineImpl engine, Policy p) {
        ArrayList<PolicyAssertion> alternatives = new ArrayList<PolicyAssertion>();
        Iterator it = p.getAlternatives();
        while (it.hasNext()) {
            List alternative = CastUtils.cast((List)((List)it.next()), PolicyAssertion.class);
            if (!engine.supportsAlternative(alternative, null)) continue;
            alternatives.addAll(alternative);
        }
        return alternatives;
    }

    void initialiseInterceptors(PolicyInterceptorProviderRegistry reg, PolicyEngineImpl engine, Set<Interceptor<? extends Message>> out, PolicyAssertion a, boolean usIn) {
        Policy p;
        QName qn = a.getName();
        PolicyInterceptorProvider pp = (PolicyInterceptorProvider)reg.get((Object)qn);
        if (null != pp) {
            out.addAll(usIn ? pp.getInInterceptors() : pp.getOutInterceptors());
        }
        if ((p = a.getPolicy()) != null) {
            for (PolicyAssertion a2 : this.getSupportedAlternatives(engine, p)) {
                this.initialiseInterceptors(reg, engine, out, a2, usIn);
            }
        }
    }

    void setPolicy(Policy ep) {
        this.policy = ep;
    }

    void setChosenAlternative(Collection<PolicyAssertion> c) {
        this.chosenAlternative = c;
    }

    void setInterceptors(List<Interceptor<? extends Message>> out) {
        this.interceptors = out;
    }
}

