/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.client.ssl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.jboss.logging.Logger;
import org.jboss.ws.core.client.ssl.JBossWSKeyManager;

public class SSLContextFactory {
    public static final String DEFAULT_SSL_PROTOCOL = "TLS";
    public static final String SSL_USE_CLIENT_MODE = "org.jboss.ws.sslUseClientMode";
    public static final String SERVER_SSL_USE_CLIENT_MODE = "org.jboss.ws.serverSslUseClientMode";
    public static final String SSL_SERVER_AUTH_MODE = "org.jboss.ws.sslServerAuthMode";
    public static final String KEY_PASSWORD = "org.jboss.ws.keyPassword";
    public static final String STANDARD_KEY_STORE_FILE_PATH = "javax.net.ssl.keyStore";
    public static final String STANDARD_KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
    public static final String STANDARD_KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    public static final String DEFAULT_KEY_STORE_TYPE = "JKS";
    public static final String DEFAULT_KEY_STORE_ALGORITHM = "SunX509";
    public static final String STANDARD_TRUST_STORE_FILE_PATH = "javax.net.ssl.trustStore";
    public static final String STANDARD_TRUST_STORE_TYPE = "javax.net.ssl.trustStoreType";
    public static final String STANDARD_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    private SSLContext sslContextServerSocketFactory = null;
    private SSLContext sslContextSocketFactory = null;
    private Provider provider = null;
    private String providerName = null;
    private String secureSocketProtocol = null;
    private KeyManager[] keyManagers = null;
    private TrustManager[] trustManagers = null;
    private SecureRandom secureRandom = null;
    private URL keyStoreFilePath = null;
    private String keyStoreType = null;
    private String keyStoreAlgorithm = null;
    private String keyStorePassword = null;
    private String keyAlias = null;
    private String keyPassword = null;
    private URL trustStoreFilePath = null;
    private String trustStoreType = null;
    private String trustStoreAlgorithm = null;
    private String trustStorePassword = null;
    private Map<String, Object> config = null;
    private Boolean socketUseClientMode = null;
    private Boolean serverSocketUseClientMode = null;
    private Boolean serverAuthMode = null;
    private static final Logger log = Logger.getLogger(SSLContextFactory.class);

    public SSLContextFactory() {
        this(null);
    }

    public SSLContextFactory(Map<String, Object> config) {
        this.config = config;
    }

    public SSLContext getSSLContext() throws IOException {
        if (this.sslContextSocketFactory == null) {
            this.initializeSocketFactorySSLContext();
        }
        return this.sslContextSocketFactory;
    }

    public SSLContext getServerSSLContext() throws IOException {
        if (this.sslContextServerSocketFactory == null) {
            this.initializeServerSocketFactorySSLContext();
        }
        return this.sslContextServerSocketFactory;
    }

    public String getSecureSocketProtocol() {
        if (this.secureSocketProtocol == null) {
            if (this.config != null) {
                this.secureSocketProtocol = (String)this.config.get("org.jboss.ws.sslProtocol");
            }
            if (this.secureSocketProtocol == null) {
                this.secureSocketProtocol = DEFAULT_SSL_PROTOCOL;
            }
        }
        return this.secureSocketProtocol;
    }

    public void setSecureSocketProtocol(String protocol) {
        if (protocol == null || protocol.length() <= 0) {
            throw new IllegalArgumentException("Can not set remoting socket factory with null protocol");
        }
        this.secureSocketProtocol = protocol;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public String getProviderName() {
        if (this.providerName == null && this.config != null) {
            this.providerName = (String)this.config.get("org.jboss.ws.sslProviderName");
        }
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public SecureRandom getSecureRandom() {
        if (this.secureRandom != null) {
            return this.secureRandom;
        }
        this.secureRandom = new SecureRandom();
        return this.secureRandom;
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
    }

    public String getKeyStoreURL() {
        URL keyStore = this.getKeyStore();
        if (keyStore != null) {
            return keyStore.toString();
        }
        return null;
    }

    public URL getKeyStore() {
        String path;
        if (this.keyStoreFilePath != null) {
            return this.keyStoreFilePath;
        }
        if (this.config != null && (path = (String)this.config.get("org.jboss.ws.keyStore")) != null && path.length() > 0) {
            this.setKeyStoreURL(path);
        }
        if (this.keyStoreFilePath == null && (path = System.getProperty(STANDARD_KEY_STORE_FILE_PATH)) != null && path.length() > 0) {
            this.setKeyStoreURL(path);
        }
        return this.keyStoreFilePath;
    }

    public void setKeyStoreURL(String keyStoreFilePath) {
        try {
            this.keyStoreFilePath = this.validateStoreURL(keyStoreFilePath);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot validate the store URL: " + keyStoreFilePath, e);
        }
    }

    public void setKeyStore(URL keyStore) {
        this.keyStoreFilePath = keyStore;
    }

    public String getKeyStoreType() {
        String type;
        if (this.keyStoreType != null) {
            return this.keyStoreType;
        }
        if (this.config != null && (type = (String)this.config.get("org.jboss.ws.keyStoreType")) != null && type.length() > 0) {
            this.keyStoreType = type;
        }
        if (this.keyStoreType == null) {
            this.keyStoreType = System.getProperty(STANDARD_KEY_STORE_TYPE);
            if (this.keyStoreType == null) {
                this.keyStoreType = DEFAULT_KEY_STORE_TYPE;
            }
        }
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getKeyStoreAlgorithm() {
        String alg;
        if (this.keyStoreAlgorithm != null) {
            return this.keyStoreAlgorithm;
        }
        if (this.config != null && (alg = (String)this.config.get("org.jboss.ws.keyStoreAlgorithm")) != null && alg.length() > 0) {
            this.keyStoreAlgorithm = alg;
        }
        if (this.keyStoreAlgorithm == null) {
            this.keyStoreAlgorithm = DEFAULT_KEY_STORE_ALGORITHM;
        }
        return this.keyStoreAlgorithm;
    }

    public void setKeyStoreAlgorithm(String algorithm) {
        this.keyStoreAlgorithm = algorithm;
    }

    public String getKeyStorePassword() {
        String passwd;
        if (this.keyStorePassword != null) {
            return this.keyStorePassword;
        }
        if (this.config != null && (passwd = (String)this.config.get("org.jboss.ws.keyStorePassword")) != null && passwd.length() > 0) {
            this.keyStorePassword = passwd;
        }
        if (this.keyStorePassword == null) {
            this.keyStorePassword = System.getProperty(STANDARD_KEY_STORE_PASSWORD);
        }
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getTrustStoreURL() {
        URL trustStore = this.getTrustStore();
        if (trustStore != null) {
            return trustStore.toString();
        }
        return null;
    }

    public URL getTrustStore() {
        String path;
        if (this.trustStoreFilePath != null) {
            return this.trustStoreFilePath;
        }
        if (this.config != null && (path = (String)this.config.get("org.jboss.ws.trustStore")) != null && path.length() > 0) {
            this.setTrustStoreURL(path);
        }
        if (this.trustStoreFilePath == null && (path = System.getProperty(STANDARD_TRUST_STORE_FILE_PATH)) != null && path.length() > 0) {
            this.setTrustStoreURL(path);
        }
        return this.trustStoreFilePath;
    }

    public void setTrustStore(URL trustStore) {
        this.trustStoreFilePath = trustStore;
    }

    public void setTrustStoreURL(String trustStoreFilePath) {
        try {
            this.trustStoreFilePath = this.validateStoreURL(trustStoreFilePath);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot validate the store URL: " + trustStoreFilePath, e);
        }
    }

    public String getTrustStoreType() {
        String type;
        if (this.trustStoreType != null) {
            return this.trustStoreType;
        }
        if (this.config != null && (type = (String)this.config.get("org.jboss.ws.trustStoreType")) != null && type.length() > 0) {
            this.trustStoreType = type;
        }
        if (this.trustStoreType == null) {
            this.trustStoreType = System.getProperty(STANDARD_TRUST_STORE_TYPE);
            if (this.trustStoreType == null) {
                this.trustStoreType = this.getKeyStoreType();
            }
        }
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public String getTrustStoreAlgorithm() {
        String alg;
        if (this.trustStoreAlgorithm != null) {
            return this.trustStoreAlgorithm;
        }
        if (this.config != null && (alg = (String)this.config.get("org.jboss.ws.trustStoreAlgorithm")) != null && alg.length() > 0) {
            this.trustStoreAlgorithm = alg;
        }
        if (this.trustStoreAlgorithm == null) {
            this.trustStoreAlgorithm = this.getKeyStoreAlgorithm();
        }
        return this.trustStoreAlgorithm;
    }

    public void setTrustStoreAlgorithm(String algorithm) {
        this.trustStoreAlgorithm = algorithm;
    }

    public String getTrustStorePassword() {
        String passwd;
        if (this.trustStorePassword != null) {
            return this.trustStorePassword;
        }
        if (this.config != null && (passwd = (String)this.config.get("org.jboss.ws.trustStorePassword")) != null && passwd.length() > 0) {
            this.trustStorePassword = passwd;
        }
        if (this.trustStorePassword == null) {
            this.trustStorePassword = System.getProperty(STANDARD_TRUST_STORE_PASSWORD);
            if (this.trustStorePassword == null) {
                this.trustStorePassword = this.getKeyStorePassword();
            }
        }
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String getKeyAlias() {
        if (this.keyAlias != null) {
            return this.keyAlias;
        }
        if (this.config != null) {
            this.keyAlias = (String)this.config.get("org.jboss.ws.keyAlias");
        }
        return this.keyAlias;
    }

    public void setKeyAlias(String alias) {
        this.keyAlias = alias;
    }

    public String getKeyPassword() {
        String passwd;
        if (this.keyPassword != null) {
            return this.keyPassword;
        }
        if (this.config != null && (passwd = (String)this.config.get(KEY_PASSWORD)) != null && passwd.length() > 0) {
            this.keyPassword = passwd;
        }
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public boolean isSocketUseClientMode() {
        if (this.socketUseClientMode == null) {
            this.socketUseClientMode = this.config != null && this.config.containsKey(SSL_USE_CLIENT_MODE) ? Boolean.valueOf((String)this.config.get(SSL_USE_CLIENT_MODE)) : Boolean.TRUE;
        }
        return this.socketUseClientMode;
    }

    public boolean isServerSocketUseClientMode() {
        if (this.serverSocketUseClientMode == null) {
            this.serverSocketUseClientMode = this.config != null && this.config.containsKey(SERVER_SSL_USE_CLIENT_MODE) ? Boolean.valueOf((String)this.config.get(SERVER_SSL_USE_CLIENT_MODE)) : Boolean.FALSE;
        }
        return this.serverSocketUseClientMode;
    }

    public void setSocketUseClientMode(boolean useClientMode) {
        this.socketUseClientMode = useClientMode;
    }

    public void setServerSocketUseClientMode(boolean useClientMode) {
        this.serverSocketUseClientMode = useClientMode;
    }

    public boolean isServerAuthMode() {
        if (this.serverAuthMode == null) {
            this.serverAuthMode = this.config != null && this.config.containsKey(SSL_SERVER_AUTH_MODE) ? Boolean.valueOf((String)this.config.get(SSL_SERVER_AUTH_MODE)) : Boolean.TRUE;
        }
        return this.serverAuthMode;
    }

    public void setServerAuthMode(boolean mode) {
        this.serverAuthMode = mode;
    }

    protected void createServerSocketFactorySSLContext() throws IOException {
        try {
            this.sslContextServerSocketFactory = this.getProvider() != null ? SSLContext.getInstance(this.getSecureSocketProtocol(), this.getProvider()) : (this.getProviderName() != null ? SSLContext.getInstance(this.getSecureSocketProtocol(), this.getProviderName()) : SSLContext.getInstance(this.getSecureSocketProtocol()));
        }
        catch (Exception e) {
            IOException ioe = new IOException("Error creating server socket factory SSL context: " + e.getMessage());
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
    }

    protected void createSocketFactorySSLContext() throws IOException {
        try {
            this.sslContextSocketFactory = this.getProvider() != null ? SSLContext.getInstance(this.getSecureSocketProtocol(), this.getProvider()) : (this.getProviderName() != null ? SSLContext.getInstance(this.getSecureSocketProtocol(), this.getProviderName()) : SSLContext.getInstance(this.getSecureSocketProtocol()));
        }
        catch (Exception e) {
            IOException ioe = new IOException("Error creating socket factory SSL context: " + e.getMessage());
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
    }

    protected void initializeServerSocketFactorySSLContext() throws IOException {
        try {
            if (this.sslContextServerSocketFactory == null) {
                this.createServerSocketFactorySSLContext();
            }
            try {
                this.keyManagers = this.loadKeyManagers();
            }
            catch (NullStoreURLException e) {
                if (this.isServerSocketUseClientMode()) {
                    this.keyManagers = null;
                    log.debugf("Could not find keytore url. %s", new Object[]{e.getMessage()});
                }
                IOException ioe = new IOException("Can not find keystore url.");
                ioe.initCause(e);
                throw ioe;
            }
            try {
                boolean isClientMode = this.isServerSocketUseClientMode();
                this.trustManagers = this.loadTrustManagers(isClientMode);
            }
            catch (NullStoreURLException e) {
                this.trustManagers = null;
                log.debugf("Could not find truststore url.  %s", new Object[]{e.getMessage()});
            }
            this.secureRandom = this.getSecureRandom();
            this.sslContextServerSocketFactory.init(this.keyManagers, this.trustManagers, this.secureRandom);
        }
        catch (Exception e) {
            IOException ioe = new IOException("Error initializing server socket factory SSL context: " + e.getMessage());
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
    }

    protected void initializeSocketFactorySSLContext() throws IOException {
        try {
            if (this.sslContextSocketFactory == null) {
                this.createSocketFactorySSLContext();
            }
            try {
                this.keyManagers = this.loadKeyManagers();
            }
            catch (NullStoreURLException e) {
                this.keyManagers = null;
                log.debugf("Could not find keystore url. %s ", new Object[]{e.getMessage()});
            }
            try {
                boolean isClientMode = this.isSocketUseClientMode();
                this.trustManagers = this.loadTrustManagers(isClientMode);
            }
            catch (NullStoreURLException e) {
                if (this.keyManagers != null) {
                    this.trustManagers = null;
                    log.debugf("Could not find truststore url. %s", new Object[]{e.getMessage()});
                }
                IOException ioe = new IOException("Can not find truststore url.");
                ioe.initCause(e);
                throw ioe;
            }
            this.secureRandom = this.getSecureRandom();
            this.sslContextSocketFactory.init(this.keyManagers, this.trustManagers, this.secureRandom);
        }
        catch (Exception e) {
            IOException ioe = new IOException("Error initializing socket factory SSL context: " + e.getMessage());
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
    }

    protected TrustManager[] loadTrustManagers(boolean isClientMode) throws NoSuchProviderException, NoSuchAlgorithmException, IOException, CertificateException, KeyStoreException, NullStoreURLException {
        if (isClientMode && !this.isServerAuthMode()) {
            this.trustManagers = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
        } else {
            String tsType = this.getTrustStoreType();
            String tsPasswd = this.getTrustStorePassword();
            URL tsPathURL = this.getTrustStore();
            String tsAlg = this.getTrustStoreAlgorithm();
            KeyStore trustStore = this.loadKeyStore(tsType, tsPathURL, tsPasswd);
            TrustManagerFactory trustMgrFactory = this.getProvider() != null ? TrustManagerFactory.getInstance(tsAlg, this.getProvider()) : (this.getProviderName() != null ? TrustManagerFactory.getInstance(tsAlg, this.getProviderName()) : TrustManagerFactory.getInstance(tsAlg));
            if (trustStore != null) {
                trustMgrFactory.init(trustStore);
                this.trustManagers = trustMgrFactory.getTrustManagers();
            }
        }
        return this.trustManagers;
    }

    protected KeyManager[] loadKeyManagers() throws NoSuchProviderException, NoSuchAlgorithmException, IOException, CertificateException, KeyStoreException, UnrecoverableKeyException, NullStoreURLException {
        URL ksPathURL;
        String ksPasswd = this.getKeyStorePassword();
        String ksType = this.getKeyStoreType();
        KeyStore keyStore = this.loadKeyStore(ksType, ksPathURL = this.getKeyStore(), ksPasswd);
        if (keyStore != null) {
            boolean containsAlias;
            String alias = this.getKeyAlias();
            if (alias != null && !(containsAlias = keyStore.isKeyEntry(alias))) {
                throw new IOException("Can not find key entry for key store (" + ksPathURL + ") with given alias (" + alias + ")");
            }
            KeyManagerFactory keyMgrFactory = null;
            String alg = this.getKeyStoreAlgorithm();
            keyMgrFactory = this.getProvider() != null ? KeyManagerFactory.getInstance(alg, this.getProvider()) : (this.getProviderName() != null ? KeyManagerFactory.getInstance(alg, this.getProviderName()) : KeyManagerFactory.getInstance(alg));
            String keyPasswd = this.getKeyPassword();
            if (keyPasswd == null || keyPasswd.length() == 0) {
                keyPasswd = ksPasswd;
            }
            keyMgrFactory.init(keyStore, keyPasswd.toCharArray());
            this.keyManagers = keyMgrFactory.getKeyManagers();
            if (alias != null) {
                for (int x = 0; x < this.keyManagers.length; ++x) {
                    this.keyManagers[x] = new JBossWSKeyManager((X509KeyManager)this.keyManagers[x], alias);
                }
            }
        }
        return this.keyManagers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyStore loadKeyStore(String storeType, URL storePathURL, String storePassword) throws KeyStoreException, NoSuchProviderException, IOException, NoSuchAlgorithmException, CertificateException, NullStoreURLException {
        KeyStore keyStore = null;
        keyStore = this.getProvider() != null ? KeyStore.getInstance(storeType, this.getProvider()) : (this.getProviderName() != null ? KeyStore.getInstance(storeType, this.getProviderName()) : KeyStore.getInstance(storeType));
        if (storePathURL == null) {
            throw new NullStoreURLException("Can not find store file for url because store url is null.");
        }
        InputStream keyStoreInputStream = null;
        try {
            keyStoreInputStream = storePathURL.openStream();
            char[] password = storePassword != null ? storePassword.toCharArray() : null;
            keyStore.load(keyStoreInputStream, password);
        }
        finally {
            if (keyStoreInputStream != null) {
                try {
                    keyStoreInputStream.close();
                }
                catch (IOException e) {}
                keyStoreInputStream = null;
            }
        }
        return keyStore;
    }

    protected URL validateStoreURL(String storePath) throws IOException {
        URL url;
        block4: {
            url = null;
            try {
                url = new URL(storePath);
            }
            catch (MalformedURLException e) {
                File tst = new File(storePath);
                if (tst.exists()) {
                    url = tst.toURL();
                }
                if (url != null) break block4;
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                url = loader.getResource(storePath);
            }
        }
        if (url == null) {
            String msg = "Failed to find url=" + storePath + " as a URL, file or resource";
            throw new MalformedURLException(msg);
        }
        return url;
    }

    protected class NullStoreURLException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NullStoreURLException(String message) {
            super(message);
        }
    }
}

