/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployers;

import java.util.ArrayList;
import java.util.Collection;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.DataSourceMetaData;
import org.jboss.metadata.javaee.spec.DataSourcesMetaData;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEComponentInformer;
import org.jboss.resource.deployers.DataSourceDeployerHelper;
import org.jboss.resource.metadata.mcf.DataSourceDeploymentMetaData;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentGroup;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;

public abstract class AbstractDataSourceDeployer
extends AbstractDeployer {
    private static final Logger logger = Logger.getLogger(AbstractDataSourceDeployer.class);
    private JavaEEComponentInformer informer;

    public AbstractDataSourceDeployer() {
        this.setStage(DeploymentStages.REAL);
        this.setOutput(ManagedConnectionFactoryDeploymentGroup.class);
    }

    @Inject
    public void setJavaEEComponentInformer(JavaEEComponentInformer informer) {
        this.informer = informer;
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        DataSourcesMetaData dsmd = this.getDataSources(unit);
        if (dsmd == null) {
            return;
        }
        Collection<DataSourceDeploymentMetaData> dataSourceDeployments = this.getDataSourceDeployments(dsmd, unit);
        this.attachManagedConnectionFactories(unit, dataSourceDeployments);
    }

    protected abstract DataSourcesMetaData getDataSources(DeploymentUnit var1);

    private Collection<DataSourceDeploymentMetaData> getDataSourceDeployments(DataSourcesMetaData dataSources, DeploymentUnit unit) {
        ArrayList<DataSourceDeploymentMetaData> datasourceDeployments = new ArrayList<DataSourceDeploymentMetaData>();
        for (String key : dataSources.keySet()) {
            DataSourceMetaData dsmd = (DataSourceMetaData)dataSources.get(key);
            DataSourceDeploymentMetaData deploymentMetaData = DataSourceDeployerHelper.createDeployment(dsmd);
            deploymentMetaData.setJndiName(DataSourceDeployerHelper.normalizeJndiName(dsmd, unit, this.informer));
            datasourceDeployments.add(deploymentMetaData);
        }
        return datasourceDeployments;
    }

    private void attachManagedConnectionFactories(DeploymentUnit unit, Collection<DataSourceDeploymentMetaData> datasourceDeployments) {
        DeploymentUnit nonComponentDU = unit.isComponent() ? unit.getParent() : unit;
        ManagedConnectionFactoryDeploymentGroup managedConnectionFactories = (ManagedConnectionFactoryDeploymentGroup)nonComponentDU.getAttachment(ManagedConnectionFactoryDeploymentGroup.class);
        if (managedConnectionFactories == null) {
            managedConnectionFactories = new ManagedConnectionFactoryDeploymentGroup();
        }
        for (DataSourceDeploymentMetaData dataSourceDeployment : datasourceDeployments) {
            managedConnectionFactories.addManagedConnectionFactoryDeployment((ManagedConnectionFactoryDeploymentMetaData)dataSourceDeployment);
        }
        nonComponentDU.addAttachment(ManagedConnectionFactoryDeploymentGroup.class, (Object)managedConnectionFactories);
    }
}

