/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.reflect.plugins.ClassInfoHelper;
import org.jboss.reflect.plugins.ConstructorInfoImpl;
import org.jboss.reflect.plugins.FieldInfoImpl;
import org.jboss.reflect.plugins.InheritableAnnotationHolder;
import org.jboss.reflect.plugins.MethodInfoImpl;
import org.jboss.reflect.plugins.TypeInfoAttachments;
import org.jboss.reflect.plugins.ValueConvertor;
import org.jboss.reflect.plugins.introspection.IntrospectionTypeInfoFactory;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.DelegateClassInfo;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.InterfaceInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.PackageInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfoImpl
extends InheritableAnnotationHolder
implements ClassInfo {
    private static final long serialVersionUID = 3545798779904340792L;
    public static final ClassInfo UNKNOWN_CLASS = new DelegateClassInfo(null, true);
    public static final ClassInfo[] UNKNOWN_CLASSES = new ClassInfo[0];
    public static final TypeInfo UNKNOWN_TYPE = UNKNOWN_CLASS;
    public static final TypeInfo[] UNKNOWN_TYPES = new TypeInfo[0];
    public static final InterfaceInfo[] UNKNOWN_INTERFACES = new InterfaceInfo[0];
    public static final ConstructorInfo[] UNKNOWN_CONSTRUCTORS = new ConstructorInfo[0];
    public static final MethodInfo[] UNKNOWN_METHODS = new MethodInfo[0];
    public static final FieldInfo[] UNKNOWN_FIELDS = new FieldInfo[0];
    protected String name;
    protected int modifiers;
    protected InterfaceInfo[] interfaces = UNKNOWN_INTERFACES;
    protected InterfaceInfo[] genericInterfaces = UNKNOWN_INTERFACES;
    protected MethodInfo[] methods = UNKNOWN_METHODS;
    protected FieldInfo[] fields = UNKNOWN_FIELDS;
    protected HashMap<String, FieldInfo> fieldMap;
    protected ClassInfo superclass = UNKNOWN_CLASS;
    protected ClassInfo genericSuperclass = UNKNOWN_CLASS;
    protected ConstructorInfo[] constructors = UNKNOWN_CONSTRUCTORS;
    protected PackageInfo packageInfo;
    private transient TypeInfo componentType = UNKNOWN_TYPE;
    private transient TypeInfo keyType = UNKNOWN_TYPE;
    private transient TypeInfo valueType = UNKNOWN_TYPE;
    protected transient ClassInfoHelper classInfoHelper;
    protected transient TypeInfoFactory typeInfoFactory;
    private transient TypeInfoAttachments attachments;

    public ClassInfoImpl() {
    }

    public ClassInfoImpl(String name) {
        this.name = name;
    }

    public ClassInfoImpl(String name, int modifiers) {
        this.name = name;
        this.modifiers = modifiers;
    }

    public ClassInfoImpl(String name, int modifiers, InterfaceInfo[] interfaces, ClassInfoImpl superclass) {
        this.name = name;
        this.modifiers = modifiers;
        this.interfaces = interfaces;
        this.superclass = superclass;
    }

    @Override
    public AnnotationValue[] getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    @Override
    public AnnotationValue getAnnotation(String name) {
        return this.getDeclaredAnnotation(name);
    }

    @Override
    public boolean isAnnotationPresent(String name) {
        return this.isDeclaredAnnotationPresent(name);
    }

    @Override
    public TypeInfoFactory getTypeInfoFactory() {
        return this.typeInfoFactory;
    }

    public void setTypeInfoFactory(TypeInfoFactory typeInfoFactory) {
        this.typeInfoFactory = typeInfoFactory;
    }

    public void setClassInfoHelper(ClassInfoHelper classInfoHelper) {
        this.classInfoHelper = classInfoHelper;
    }

    public static MethodInfo findMethod(MethodInfo[] methods, String name, TypeInfo[] parameters) {
        if (methods == null) {
            return null;
        }
        for (int i = 0; i < methods.length; ++i) {
            int length;
            if (!methods[i].getName().equals(name)) continue;
            int n = length = parameters != null ? parameters.length : 0;
            if (methods[i].getParameterTypes().length != length) continue;
            boolean ok = true;
            for (int j = 0; j < length; ++j) {
                if (parameters[j].equals(methods[i].getParameterTypes()[j])) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            return methods[i];
        }
        return null;
    }

    public static ConstructorInfo findConstructor(ConstructorInfo[] constructors, TypeInfo[] parameters) {
        if (constructors == null) {
            return null;
        }
        for (int i = 0; i < constructors.length; ++i) {
            int length;
            int n = length = parameters != null ? parameters.length : 0;
            if (constructors[i].getParameterTypes().length != length) continue;
            boolean ok = true;
            for (int j = 0; j < length; ++j) {
                if (parameters[j].equals(constructors[i].getParameterTypes()[j])) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            return constructors[i];
        }
        return null;
    }

    public static Class<?> getArrayClass(Class<?> clazz) {
        return Array.newInstance(clazz, 0).getClass();
    }

    public void setType(Class<?> type) {
        this.setAnnotatedElement(type);
        if (type != null) {
            this.modifiers = type.getModifiers();
        }
    }

    public void setInterfaces(InterfaceInfo[] interfaces) {
        this.interfaces = interfaces;
    }

    public void setGenericInterfaces(InterfaceInfo[] interfaces) {
        this.genericInterfaces = interfaces;
    }

    public void setDeclaredMethods(MethodInfoImpl[] methods) {
        this.methods = methods;
        if (methods != null) {
            for (int i = 0; i < methods.length; ++i) {
                methods[i].declaringClass = this;
            }
        }
    }

    public void setDeclaredFields(FieldInfoImpl[] fields) {
        this.fields = fields;
        if (fields != null) {
            this.fieldMap = new HashMap(fields.length);
            for (int i = 0; i < fields.length; ++i) {
                fields[i].declaringClass = this;
                this.fieldMap.put(fields[i].getName(), fields[i]);
            }
        }
    }

    public void setDeclaredConstructors(ConstructorInfoImpl[] constructors) {
        this.constructors = constructors;
        if (constructors != null) {
            for (int i = 0; i < constructors.length; ++i) {
                constructors[i].declaringClass = this;
            }
        }
    }

    void setSuperclass(ClassInfo superInfo) {
        this.superclass = superInfo;
    }

    public void setGenericSuperclass(ClassInfo superInfo) {
        this.genericSuperclass = superInfo;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public InterfaceInfo[] getInterfaces() {
        if (this.interfaces == UNKNOWN_INTERFACES) {
            this.setInterfaces(this.classInfoHelper.getInterfaces(this));
        }
        return this.interfaces;
    }

    @Override
    public InterfaceInfo[] getGenericInterfaces() {
        if (this.genericInterfaces == UNKNOWN_INTERFACES) {
            this.setGenericInterfaces(this.classInfoHelper.getGenericInterfaces(this));
        }
        return this.genericInterfaces;
    }

    @Override
    public MethodInfo getDeclaredMethod(String methodName, TypeInfo ... parameters) {
        if (this.methods == UNKNOWN_METHODS) {
            this.setDeclaredMethods(this.classInfoHelper.getMethods(this));
        }
        return ClassInfoImpl.findMethod(this.methods, methodName, parameters);
    }

    @Override
    public MethodInfo[] getDeclaredMethods() {
        if (this.methods == UNKNOWN_METHODS) {
            this.setDeclaredMethods(this.classInfoHelper.getMethods(this));
        }
        return this.methods;
    }

    @Override
    public FieldInfo getDeclaredField(String fieldName) {
        if (this.fields == UNKNOWN_FIELDS) {
            this.setDeclaredFields(this.classInfoHelper.getFields(this));
        }
        if (this.fieldMap == null) {
            return null;
        }
        return this.fieldMap.get(fieldName);
    }

    @Override
    public FieldInfo[] getDeclaredFields() {
        if (this.fields == UNKNOWN_FIELDS) {
            this.setDeclaredFields(this.classInfoHelper.getFields(this));
        }
        return this.fields;
    }

    @Override
    public ConstructorInfo getDeclaredConstructor(TypeInfo ... parameters) {
        if (this.constructors == UNKNOWN_CONSTRUCTORS) {
            this.setDeclaredConstructors(this.classInfoHelper.getConstructors(this));
        }
        return ClassInfoImpl.findConstructor(this.constructors, parameters);
    }

    @Override
    public ConstructorInfo[] getDeclaredConstructors() {
        if (this.constructors == UNKNOWN_CONSTRUCTORS) {
            this.setDeclaredConstructors(this.classInfoHelper.getConstructors(this));
        }
        return this.constructors;
    }

    @Override
    public ClassInfo getSuperclass() {
        if (this.superclass == UNKNOWN_CLASS) {
            this.setSuperclass(this.classInfoHelper.getSuperClass(this));
        }
        return this.superclass;
    }

    @Override
    public ClassInfo getGenericSuperclass() {
        if (this.genericSuperclass == UNKNOWN_CLASS) {
            this.setGenericSuperclass(this.classInfoHelper.getGenericSuperClass(this));
        }
        return this.genericSuperclass;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    @Override
    public boolean isVolatile() {
        return Modifier.isVolatile(this.modifiers);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSimpleName() {
        return this.getType().getSimpleName();
    }

    @Deprecated
    public Class<? extends Object> getType() {
        return (Class)this.annotatedElement;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.getType().getClassLoader();
    }

    @Override
    public Object convertValue(Object value) throws Throwable {
        return ValueConvertor.convertValue(this.getType(), value);
    }

    @Override
    public Object convertValue(Object value, boolean replaceProperties) throws Throwable {
        return ValueConvertor.convertValue(this.getType(), value, replaceProperties);
    }

    @Override
    public Object convertValue(Object value, boolean replaceProperties, boolean trim) throws Throwable {
        return ValueConvertor.convertValue(this.getType(), value, replaceProperties, trim);
    }

    @Override
    public boolean isArray() {
        return this.getType().isArray();
    }

    @Override
    public boolean isCollection() {
        return Collection.class.isAssignableFrom(this.getType());
    }

    @Override
    public boolean isMap() {
        return Map.class.isAssignableFrom(this.getType());
    }

    @Override
    public boolean isAnnotation() {
        return this.getType().isAnnotation();
    }

    @Override
    public boolean isEnum() {
        return this.getType().isEnum();
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public TypeInfo getArrayType() {
        Class<?> arrayClass = ClassInfoImpl.getArrayClass(this.getType());
        return this.classInfoHelper.getTypeInfo(arrayClass);
    }

    @Override
    public Object newArrayInstance(int size) throws Throwable {
        if (!this.isArray()) {
            throw new ClassCastException(this + " is not an array.");
        }
        return Array.newInstance(this.getComponentType().getType(), size);
    }

    @Override
    public boolean isAssignableFrom(TypeInfo info) {
        if (info == null) {
            throw new NullPointerException("Parameter info cannot be null!");
        }
        return this.getType().isAssignableFrom(info.getType());
    }

    @Override
    public boolean isInstance(Object object) {
        return this.getType().isInstance(object);
    }

    @Override
    public TypeInfo[] getActualTypeArguments() {
        return UNKNOWN_TYPES;
    }

    @Override
    public TypeInfo getOwnerType() {
        return null;
    }

    @Override
    public ClassInfo getRawType() {
        return this;
    }

    @Override
    public TypeInfo getComponentType() {
        if (this.componentType == UNKNOWN_TYPE) {
            this.componentType = this.classInfoHelper.getComponentType(this);
        }
        return this.componentType;
    }

    @Override
    public TypeInfo getKeyType() {
        if (this.keyType == UNKNOWN_TYPE) {
            this.keyType = this.classInfoHelper.getKeyType(this);
        }
        return this.keyType;
    }

    @Override
    public TypeInfo getValueType() {
        if (this.valueType == UNKNOWN_TYPE) {
            this.valueType = this.classInfoHelper.getValueType(this);
        }
        return this.valueType;
    }

    @Override
    public PackageInfo getPackage() {
        if (this.packageInfo == null) {
            this.packageInfo = this.classInfoHelper.getPackage(this);
        }
        return this.packageInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttachment(String name, Object attachment) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        ClassInfoImpl classInfoImpl = this;
        synchronized (classInfoImpl) {
            if (this.attachments == null) {
                if (attachment == null) {
                    return;
                }
                this.attachments = new TypeInfoAttachments();
            }
        }
        if (attachment == null) {
            this.attachments.removeAttachment(name);
        } else {
            this.attachments.addAttachment(name, attachment);
        }
    }

    @Override
    public <T> T getAttachment(Class<T> expectedType) {
        if (expectedType == null) {
            throw new IllegalArgumentException("Null expectedType");
        }
        Object result = this.getAttachment(expectedType.getName());
        if (result == null) {
            return null;
        }
        return expectedType.cast(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttachment(String attachName) {
        if (attachName == null) {
            throw new IllegalArgumentException("Null name");
        }
        ClassInfoImpl classInfoImpl = this;
        synchronized (classInfoImpl) {
            if (this.attachments == null) {
                return null;
            }
        }
        return this.attachments.getAttachment(attachName);
    }

    @Override
    protected ClassInfo getSuperHolder() {
        return this.getSuperclass();
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ClassInfo)) {
            return false;
        }
        ClassInfo other = (ClassInfo)obj;
        String thisName = this.getName();
        return !(thisName != null ? !thisName.equals(other.getName()) : other.getName() != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    protected Object writeReplace() {
        return new MarshalledClassInfo(this.getType());
    }

    @Override
    public String getTypeVariable() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MarshalledClassInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        Class<?> type;

        public MarshalledClassInfo(Class<?> type) {
            this.type = type;
        }

        protected Object readResolve() {
            IntrospectionTypeInfoFactory tif = new IntrospectionTypeInfoFactory();
            return tif.getTypeInfo(this.type);
        }
    }
}

