/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.bytecode;

import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javassist.bytecode.Descriptor;
import javassist.bytecode.SignatureAttribute;
import org.jboss.reflect.plugins.AnnotationAttributeImpl;
import org.jboss.reflect.plugins.AnnotationHelper;
import org.jboss.reflect.plugins.AnnotationValueFactory;
import org.jboss.reflect.plugins.AnnotationValueImpl;
import org.jboss.reflect.plugins.EnumConstantInfoImpl;
import org.jboss.reflect.plugins.GenericsUtil;
import org.jboss.reflect.plugins.TypeVariableAware;
import org.jboss.reflect.plugins.bytecode.BytecodeAnnotationInfo;
import org.jboss.reflect.plugins.bytecode.BytecodeArrayInfoImpl;
import org.jboss.reflect.plugins.bytecode.BytecodeEnumInfo;
import org.jboss.reflect.plugins.bytecode.BytecodeGenericsHelper;
import org.jboss.reflect.plugins.bytecode.BytecodeParameterizedClassInfo;
import org.jboss.reflect.plugins.bytecode.BytecodeTypeInfo;
import org.jboss.reflect.plugins.bytecode.BytecodeTypeVariableSpy;
import org.jboss.reflect.plugins.bytecode.ClassLoaderFinder;
import org.jboss.reflect.plugins.bytecode.SecurityActions;
import org.jboss.reflect.plugins.bytecode.SignatureKey;
import org.jboss.reflect.plugins.bytecode.bytes.BytecodePrimitive;
import org.jboss.reflect.plugins.bytecode.bytes.ClassBytes;
import org.jboss.reflect.plugins.bytecode.bytes.ClassBytesFactory;
import org.jboss.reflect.plugins.bytecode.bytes.FieldBytes;
import org.jboss.reflect.plugins.bytecode.bytes.MemberBytes;
import org.jboss.reflect.plugins.bytecode.bytes.MethodBytes;
import org.jboss.reflect.plugins.bytecode.bytes.asm.AsmClassBytesFactory;
import org.jboss.reflect.plugins.introspection.IntrospectionTypeInfoFactory;
import org.jboss.reflect.spi.AnnotationInfo;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ArrayInfo;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.DelegateClassInfo;
import org.jboss.reflect.spi.NumberInfo;
import org.jboss.reflect.spi.PrimitiveInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;
import org.jboss.util.collection.WeakClassCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BytecodeTypeInfoFactoryImpl
extends WeakClassCache<TypeInfo>
implements TypeInfoFactory,
AnnotationHelper {
    private final ClassBytesFactory classBytesFactory = AsmClassBytesFactory.INSTANCE;
    private static ThreadLocal<Map<ClassBytes, TypeInfo>> results = new ThreadLocal();
    private volatile ClassLoaderFinder finder;
    static final AnnotationValue[] NO_ANNOTATIONS = new AnnotationValue[0];

    public BytecodeTypeInfoFactoryImpl() {
        this.setClassLoaderFinder(null);
    }

    ClassBytesFactory getClassBytesFactory() {
        return this.classBytesFactory;
    }

    public ClassLoaderFinder getClassLoaderFinder() {
        return this.finder;
    }

    public void setClassLoaderFinder(ClassLoaderFinder finder) {
        if (finder == null) {
            this.finder = ClassLoaderFinder.LoadClass.INSTANCE;
            return;
        }
        this.finder = finder;
    }

    private ClassLoader findClassLoaderForClass(ClassLoader initiating, String name) {
        BytecodePrimitive primitive;
        int end;
        int start = 0;
        while (name.charAt(start) == '[') {
            ++start;
        }
        for (end = name.length() - 1; end > start && name.charAt(end) == ']' && name.charAt(end - 1) == '['; end -= 2) {
        }
        if (start > 0 || end < name.length() - 1) {
            name = name.substring(0, end + 1);
        }
        if ((primitive = BytecodePrimitive.valueOf(name)) != null) {
            return SecurityActions.getSystemClassLoader();
        }
        return this.finder.getLoaderForClass(initiating, name);
    }

    protected TypeInfo instantiate(Class clazz) {
        ClassBytes classBytes = this.loadClassBytes(this.getClassLoader(clazz), clazz.getName());
        return this.instantiate(clazz.getName(), classBytes, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected TypeInfo instantiate(String name, ClassBytes classBytes, Class<?> clazz) {
        int i;
        AnnotationAttributeImpl[] atttributes;
        MethodBytes[] methods;
        BytecodeAnnotationInfo result;
        TypeInfo cached;
        boolean start = false;
        Map<ClassBytes, TypeInfo> tmp = results.get();
        if (tmp == null) {
            start = true;
            tmp = new HashMap<ClassBytes, TypeInfo>();
            results.set(tmp);
        }
        if ((cached = tmp.get(classBytes)) != null) {
            return cached;
        }
        try {
            if (classBytes.getComponentType() != null) {
                try {
                    TypeInfo componentType = this.getTypeInfo(classBytes.getComponentType().getTypeInfoName(), classBytes.getClassLoader());
                    BytecodeArrayInfoImpl arrayInfo = new BytecodeArrayInfoImpl(this, classBytes, clazz, componentType);
                    tmp.put(classBytes, arrayInfo);
                    BytecodeArrayInfoImpl bytecodeArrayInfoImpl = arrayInfo;
                    return bytecodeArrayInfoImpl;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!classBytes.isAnnotation()) {
                if (classBytes.isEnum()) {
                    BytecodeEnumInfo enumInfo = new BytecodeEnumInfo(this, name, classBytes, clazz);
                    tmp.put(classBytes, enumInfo);
                    FieldBytes[] fields = classBytes.getDeclaredFieldBytes();
                    ArrayList<EnumConstantInfoImpl> constants = new ArrayList<EnumConstantInfoImpl>();
                    FieldBytes[] arr$ = fields;
                    int len$ = arr$.length;
                    int i$ = 0;
                    while (true) {
                        if (i$ >= len$) {
                            enumInfo.setEnumConstants(constants.toArray(new EnumConstantInfoImpl[constants.size()]));
                            BytecodeEnumInfo bytecodeEnumInfo = enumInfo;
                            return bytecodeEnumInfo;
                        }
                        FieldBytes field = arr$[i$];
                        if (field.isEnumConstant()) {
                            AnnotationValue[] annotations = this.getAnnotations(field);
                            constants.add(new EnumConstantInfoImpl(field.getName(), enumInfo, annotations));
                        }
                        ++i$;
                    }
                }
                BytecodeTypeInfo typeInfo = new BytecodeTypeInfo(this, name, classBytes, clazz);
                tmp.put(classBytes, typeInfo);
                BytecodeTypeInfo bytecodeTypeInfo = typeInfo;
                return bytecodeTypeInfo;
            }
            result = new BytecodeAnnotationInfo(this, name, classBytes, clazz);
            tmp.put(classBytes, result);
            methods = classBytes.getDeclaredMethodBytes();
            atttributes = new AnnotationAttributeImpl[methods.length];
            i = 0;
        }
        finally {
            if (start) {
                results.remove();
            }
        }
        while (true) {
            if (i >= methods.length) {
                result.setAttributes(atttributes);
                return result;
            }
            try {
                atttributes[i] = new AnnotationAttributeImpl(methods[i].getName(), this.getTypeInfo(SignatureKey.getReturnType(methods[i]), classBytes.getClassLoader()), null);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Error reading attribute " + methods[i].getName() + " for " + classBytes.getJvmName());
            }
            ++i;
        }
    }

    protected void generate(Class clazz, TypeInfo result) {
    }

    @Override
    public TypeInfo getTypeInfo(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null class");
        }
        return (TypeInfo)this.get(clazz);
    }

    @Override
    public TypeInfo getTypeInfo(String name, ClassLoader cl) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("Null class name");
        }
        if (cl == null) {
            cl = SecurityActions.getContextClassLoader();
        }
        return this.get(name, cl);
    }

    @Override
    public TypeInfo getTypeInfo(Type type) {
        if (type instanceof Class) {
            return this.getTypeInfo((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return this.getParameterizedType((ParameterizedType)type);
        }
        if (type instanceof WildcardType) {
            return this.getWildcardType((WildcardType)type);
        }
        if (type instanceof GenericArrayType) {
            return this.getGenericArrayType((GenericArrayType)type);
        }
        if (type instanceof TypeVariable) {
            return this.getTypeVariable((TypeVariable)type);
        }
        throw new UnsupportedOperationException("Unknown type: " + type + " class=" + type.getClass());
    }

    public TypeInfo get(String name, ClassLoader cl) throws ClassNotFoundException {
        return this.get(name, cl, null);
    }

    public TypeInfo get(Class clazz) {
        try {
            ClassLoader cl = SecurityActions.getClassLoader(clazz);
            if (cl == null) {
                cl = SecurityActions.getContextClassLoader();
            }
            return this.get(clazz.getName(), cl, clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found: " + e.getMessage());
        }
    }

    protected TypeInfo get(String name, ClassLoader cl, Class<?> clazz) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (cl == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        return this.get(null, clazz, name, cl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TypeInfo get(ClassBytes classBytes, Class<?> clazz, String name, ClassLoader cl, boolean delegateToReflectIfNotFound) throws ClassNotFoundException {
        Map<String, WeakReference<TypeInfo>> classLoaderCache;
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (cl == null) {
            throw new IllegalArgumentException("Null class loader");
        }
        PrimitiveInfo primitive = PrimitiveInfo.valueOf(name);
        if (primitive != null) {
            return primitive;
        }
        NumberInfo number = NumberInfo.valueOf(name);
        if (number != null) {
            NumberInfo numberInfo = number;
            synchronized (numberInfo) {
                if (number.getPhase() != NumberInfo.Phase.INITIALIZING) {
                    if (number.getPhase() != NumberInfo.Phase.COMPLETE) {
                        number.initializing();
                        Class<?> useClass = clazz;
                        try {
                            if (useClass == null) {
                                useClass = cl.loadClass(name);
                            }
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                        number.setDelegate((TypeInfo)this.get(useClass));
                    }
                    return number;
                }
            }
        }
        if (name.charAt(0) == '[') {
            name = Descriptor.toClassName((String)name);
        }
        Map<String, WeakReference<TypeInfo>> originalCache = classLoaderCache = this.getClassLoaderCache(cl);
        TypeInfo result = this.getFromCache(name, classLoaderCache);
        if (result != null) {
            return result;
        }
        ClassLoader real = cl;
        if (classBytes == null) {
            real = this.findClassLoaderForClass(cl, name);
            if (real == null) {
                real = cl;
            } else if (real != cl && (result = this.getFromCache(name, classLoaderCache = this.getClassLoaderCache(real))) != null) {
                originalCache.put(name, new WeakReference<TypeInfo>(result));
                return result;
            }
            classBytes = this.loadClassBytes(real, name);
        }
        if (classBytes == null) {
            if (clazz == null) {
                throw new ClassNotFoundException("Could not load " + name + " in loader " + cl);
            }
            return this.delegateToIntrospectionImplementation(cl, name);
        }
        result = this.instantiate(name, classBytes, clazz);
        WeakReference<TypeInfo> weak = new WeakReference<TypeInfo>(result);
        classLoaderCache.put(name, weak);
        if (originalCache != classLoaderCache) {
            originalCache.put(name, weak);
        }
        return result;
    }

    private ClassLoader getClassLoader(Class<?> clazz) {
        ClassLoader loader = SecurityActions.getClassLoader(clazz);
        if (loader != null) {
            return loader;
        }
        return SecurityActions.getSystemClassLoader();
    }

    private ClassLoader getClassLoader(final TypeInfo info) {
        if (System.getSecurityManager() == null) {
            return info.getClassLoader();
        }
        if (info instanceof BytecodeTypeInfo) {
            return ((BytecodeTypeInfo)info).getClassLoaderInternal();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return info.getClassLoader();
            }
        });
    }

    private TypeInfo delegateToIntrospectionImplementation(ClassLoader cl, String name) throws ClassNotFoundException {
        IntrospectionTypeInfoFactory factory = new IntrospectionTypeInfoFactory();
        return factory.getTypeInfo(name, cl);
    }

    private TypeInfo getFromCache(String name, Map<String, WeakReference<TypeInfo>> classLoaderCache) {
        WeakReference<TypeInfo> weak = classLoaderCache.get(name);
        if (weak != null) {
            return (TypeInfo)weak.get();
        }
        return null;
    }

    @Override
    public AnnotationValue[] getAnnotations(Object obj) {
        try {
            Annotation[] annotations;
            if (obj instanceof ClassBytes) {
                annotations = ((ClassBytes)obj).getAnnotations();
            } else if (obj instanceof MemberBytes) {
                annotations = ((MemberBytes)obj).getAnnotations();
            } else {
                throw new RuntimeException("Attempt was made to read annotations from unsupported type " + obj.getClass().getName() + ": " + obj);
            }
            if (annotations == null || annotations.length == 0) {
                return NO_ANNOTATIONS;
            }
            AnnotationValue[] annotationValues = new AnnotationValueImpl[annotations.length];
            for (int i = 0; i < annotations.length; ++i) {
                Class<? extends Annotation> clazz = annotations[i].annotationType();
                AnnotationInfo info = (AnnotationInfo)this.getTypeInfo(clazz);
                annotationValues[i] = AnnotationValueFactory.createAnnotationValue(this, this, info, annotations[i]);
            }
            return annotationValues;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public AnnotationValue createAnnotationValue(AnnotationInfo info, Object ann) {
        return AnnotationValueFactory.createAnnotationValue(this, this, info, ann);
    }

    protected TypeInfo getParameterizedType(ParameterizedType type) {
        Class rawType = (Class)type.getRawType();
        ClassInfo raw = (ClassInfo)this.getTypeInfo(rawType);
        Type[] types = type.getActualTypeArguments();
        return new BytecodeParameterizedClassInfo(this, raw, types);
    }

    protected TypeInfo getTypeInfo(ClassLoader loader, SignatureAttribute.Type type, BytecodeTypeVariableSpy spy) {
        if (type instanceof SignatureAttribute.ClassType) {
            return this.getTypeInfo(loader, (SignatureAttribute.ClassType)type, spy);
        }
        if (type instanceof SignatureAttribute.ArrayType) {
            return this.getGenericArrayType(loader, (SignatureAttribute.ArrayType)type, spy);
        }
        if (type instanceof SignatureAttribute.BaseType) {
            String s = String.valueOf(((SignatureAttribute.BaseType)type).getDescriptor());
            Class<?> clazz = PrimitiveInfo.getPrimativeArrayComponentType(s);
            return PrimitiveInfo.valueOf(clazz.getName());
        }
        if (type instanceof SignatureAttribute.TypeVariable) {
            TypeInfo typeInfo = this.getTypeInfo(loader, spy.getTypeBound((SignatureAttribute.TypeVariable)type), spy);
            if (typeInfo instanceof TypeVariableAware) {
                ((TypeVariableAware)((Object)typeInfo)).setTypeVariable(((SignatureAttribute.TypeVariable)type).getName());
            }
            return typeInfo;
        }
        throw new IllegalArgumentException("Bad type " + type + " - " + type.getClass().getName());
    }

    protected TypeInfo getTypeInfo(ClassLoader loader, SignatureAttribute.ClassType type, BytecodeTypeVariableSpy spy) {
        Map<String, WeakReference<TypeInfo>> cache;
        boolean isParameterized;
        boolean bl = isParameterized = type.getTypeArguments() != null && type.getTypeArguments().length > 0;
        if (!isParameterized) {
            try {
                return this.get(BytecodeGenericsHelper.getClassNameForGenericType(type), loader);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        String genericName = BytecodeGenericsHelper.getGenericName((SignatureAttribute.ObjectType)type, spy);
        TypeInfo info = this.getFromCache(genericName, cache = this.getClassLoaderCache(loader));
        if (info != null) {
            if (!(info instanceof ClassInfo)) {
                throw new IllegalStateException("Not a ClassInfo " + info);
            }
            return info;
        }
        try {
            ClassInfo delegate = (ClassInfo)this.get(BytecodeGenericsHelper.getClassNameForGenericType(type), loader);
            if (!isParameterized) {
                return delegate;
            }
            info = new BytecodeParameterizedClassInfo(this, delegate, loader, type.getTypeArguments(), spy);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        cache.put(genericName, new WeakReference<TypeInfo>(info));
        return info;
    }

    protected TypeInfo createTypeInfoForTypeArgument(SignatureAttribute.TypeArgument arg, ClassLoader loader, BytecodeTypeVariableSpy spy) {
        SignatureAttribute.ObjectType type = arg.getType();
        if (type == null) {
            try {
                return this.get(Object.class.getName(), loader, null);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (type instanceof SignatureAttribute.ClassType) {
            return this.getTypeInfo(loader, (SignatureAttribute.ClassType)type, spy);
        }
        if (type instanceof SignatureAttribute.TypeVariable) {
            return this.getTypeInfo(loader, spy.getTypeBound((SignatureAttribute.TypeVariable)type), spy);
        }
        throw new IllegalStateException("Unhandled type " + type);
    }

    protected TypeInfo getWildcardType(WildcardType type) {
        Type bound = type.getLowerBounds().length > 0 ? type.getLowerBounds()[0] : type.getUpperBounds()[0];
        return this.getTypeInfo(bound);
    }

    protected Map<String, WeakReference<TypeInfo>> getClassLoaderCache(ClassLoader cl) {
        if (cl == null) {
            cl = SecurityActions.getContextClassLoader();
        }
        return super.getClassLoaderCache(cl);
    }

    protected TypeInfo getGenericArrayType(GenericArrayType type) {
        ClassLoader cl;
        Map<String, WeakReference<TypeInfo>> cache;
        String genericName = GenericsUtil.getGenericName(type);
        TypeInfo info = this.getFromCache(genericName, cache = this.getClassLoaderCache(cl = GenericsUtil.findClassLoader(type)));
        if (info != null) {
            return info;
        }
        Type compType = type.getGenericComponentType();
        TypeInfo componentType = this.getTypeInfo(compType);
        String arrayName = this.getArrayName(componentType);
        ClassBytes clazz = this.classBytesFactory.loadClassBytes(cl, arrayName + "[]");
        info = new BytecodeArrayInfoImpl(this, clazz, null, componentType);
        cache.put(genericName, new WeakReference<TypeInfo>(info));
        return info;
    }

    protected ArrayInfo getGenericArrayType(ClassLoader cl, SignatureAttribute.ArrayType type, BytecodeTypeVariableSpy spy) {
        ModifiableArrayType wrapped = new ModifiableArrayType(type);
        return this.getGenericArrayType(cl, wrapped, spy);
    }

    protected ArrayInfo getGenericArrayType(ClassLoader cl, ModifiableArrayType type, BytecodeTypeVariableSpy spy) {
        Map<String, WeakReference<TypeInfo>> cache;
        String genericName = BytecodeGenericsHelper.getGenericName((SignatureAttribute.ObjectType)type, spy);
        ArrayInfo info = (ArrayInfo)this.getFromCache(genericName, cache = this.getClassLoaderCache(cl));
        if (info != null) {
            return info;
        }
        type.decrement();
        TypeInfo componentType = type.getDimension() > 0 ? this.getGenericArrayType(cl, type, spy) : this.getTypeInfo(cl, type.getComponentType(), spy);
        String arrayName = this.getArrayName(componentType);
        ClassBytes clazz = this.classBytesFactory.loadClassBytes(cl, arrayName + "[]");
        info = new BytecodeArrayInfoImpl(this, clazz, null, componentType);
        cache.put(genericName, new WeakReference<ArrayInfo>(info));
        return info;
    }

    private String getArrayName(TypeInfo componentType) {
        ClassBytes componentBytes = this.getClassBytes(componentType, true);
        if (!componentType.isArray()) {
            return componentBytes.getJvmName();
        }
        return componentBytes.getTypeInfoName().replace('.', '/');
    }

    private ClassBytes getClassBytes(TypeInfo typeInfo, boolean error) {
        if (typeInfo instanceof PrimitiveInfo) {
            return this.getPrimitiveClassBytes(typeInfo.getName());
        }
        if (typeInfo instanceof BytecodeTypeInfo) {
            return ((BytecodeTypeInfo)typeInfo).getClassBytes();
        }
        if (typeInfo instanceof DelegateClassInfo) {
            return this.getClassBytes(((DelegateClassInfo)typeInfo).getDelegate(), error);
        }
        if (error) {
            throw new IllegalArgumentException(typeInfo + " is not a JavassistType info, a PrimitiveTypeInfo or a JavassistParameterizedType");
        }
        return null;
    }

    private ClassBytes getPrimitiveClassBytes(String name) {
        return this.classBytesFactory.loadClassBytes(SecurityActions.getSystemClassLoader(), name);
    }

    ClassBytes loadClassBytes(ClassLoader loader, String name) {
        return this.classBytesFactory.loadClassBytes(loader, name.replace('.', '/'));
    }

    protected TypeInfo getTypeVariable(TypeVariable<?> type) {
        return this.getTypeInfo(type.getBounds()[0]);
    }

    protected static class ModifiableArrayType
    extends SignatureAttribute.ArrayType {
        int dims;

        ModifiableArrayType(SignatureAttribute.ArrayType original) {
            super(original.getDimension(), original.getComponentType());
            this.dims = original.getDimension();
        }

        public int getDimension() {
            return this.dims;
        }

        void decrement() {
            --this.dims;
        }
    }
}

