/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.env.helpers;

import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.injection.spi.EjbInjectionServices;
import org.jboss.weld.injection.spi.JpaInjectionServices;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.integration.deployer.env.bda.DeploymentImpl;
import org.jboss.weld.security.spi.SecurityServices;
import org.jboss.weld.serialization.spi.ProxyServices;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.jboss.weld.validation.spi.ValidationServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BootstrapBean {
    private final Bootstrap bootstrap;
    private final DeploymentImpl deployment;

    public BootstrapBean(Bootstrap bootstrap, DeploymentImpl deployment) {
        this.bootstrap = bootstrap;
        this.deployment = deployment;
    }

    public void setEjbServices(EjbServices ejbServices) {
        this.addDeploymentService(EjbServices.class, ejbServices);
    }

    public void setEjbInjectionServices(EjbInjectionServices service) {
        this.addBeanDeploymentArchiveService(EjbInjectionServices.class, service);
    }

    public void setJpaServices(JpaInjectionServices jpaServices) {
        this.addBeanDeploymentArchiveService(JpaInjectionServices.class, jpaServices);
    }

    public void setResourceServices(ResourceInjectionServices resourceServices) {
        this.addBeanDeploymentArchiveService(ResourceInjectionServices.class, resourceServices);
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    public void setTransactionServices(TransactionServices transactionServices) {
        this.addDeploymentService(TransactionServices.class, transactionServices);
    }

    public void setValidationServices(ValidationServices validationServices) {
        this.addDeploymentService(ValidationServices.class, validationServices);
    }

    public void setSecurityServices(SecurityServices securityServices) {
        this.addDeploymentService(SecurityServices.class, securityServices);
    }

    public void setProxyServices(ProxyServices proxyServices) {
        this.addDeploymentService(ProxyServices.class, proxyServices);
    }

    private <S extends Service> void addDeploymentService(Class<S> type, S service) {
        this.getDeployment().getServices().add(type, service);
    }

    private <S extends Service> void addBeanDeploymentArchiveService(Class<S> type, S service) {
        this.deployment.addBootstrapService(type, service);
    }

    public void boot() {
        this.bootstrap.startInitialization().deployBeans().validateBeans().endInitialization();
    }

    public Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    public void initialize() {
        this.deployment.initialize(this.bootstrap);
        this.bootstrap.startContainer((Environment)Environments.EE_INJECT, (Deployment)this.deployment);
    }

    public void shutdown() {
        this.bootstrap.shutdown();
    }
}

