/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.scanning;

import java.util.Collection;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.vfs.VirtualFile;
import org.jboss.weld.integration.deployer.scanning.WeldScanningPluginFactory;

public class HackWeldScanningPluginFactory
extends WeldScanningPluginFactory {
    protected void handleRelevantDeployment(DeploymentUnit unit) {
        JBossAppMetaData jBossAppMetaData;
        if (unit.isTopLevel() && unit instanceof VFSDeploymentUnit && (jBossAppMetaData = (JBossAppMetaData)unit.getAttachment(JBossAppMetaData.class)) != null) {
            VirtualFile lib;
            VFSDeploymentUnit vfsDU = (VFSDeploymentUnit)unit;
            VirtualFile root = vfsDU.getRoot();
            String libDir = jBossAppMetaData.getLibraryDirectory();
            if (libDir == null || libDir.length() == 0) {
                libDir = "lib";
            }
            if ((lib = root.getChild(libDir)) != null && lib.exists()) {
                Collection cpFiles = (Collection)unit.getAttachment("WELD_CLASSPATH", Collection.class);
                for (VirtualFile cp : cpFiles) {
                    if (!lib.equals(cp.getParent())) continue;
                    ResourceFilter rf = (ResourceFilter)unit.getAttachment(ResourceFilter.class.getName() + ".recurse", ResourceFilter.class);
                    if (rf == null || !rf.getClass().getName().contains("UrlExclude")) break;
                    unit.removeAttachment(ResourceFilter.class.getName() + ".recurse");
                    break;
                }
            }
        }
        super.handleRelevantDeployment(unit);
    }
}

