/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.jboss.aop.Advisor;
import org.jboss.ejb3.interceptors.aop.ExtendedAdvisor;
import org.jboss.logging.Logger;

public class ExtendedAdvisorWrapper
implements ExtendedAdvisor {
    private static final Logger log = Logger.getLogger(ExtendedAdvisorWrapper.class);
    private Advisor advisor;

    ExtendedAdvisorWrapper(Advisor advisor) {
        assert (advisor != null) : "advisor is null";
        this.advisor = advisor;
    }

    private final void checkClass(Class<?> cls) {
        if (cls != this.advisor.getClazz()) {
            throw new IllegalArgumentException("Can't advise on " + cls + " (only on " + this.advisor.getClazz() + ")");
        }
    }

    @Override
    public boolean isAnnotationPresent(Class<?> cls, Class<? extends Annotation> annotationType) {
        this.checkClass(cls);
        return this.advisor.hasAnnotation(cls, annotationType);
    }

    @Override
    public boolean isAnnotationPresent(Class<?> cls, Member member, Class<? extends Annotation> annotationType) {
        this.checkClass(cls);
        if (member instanceof Constructor) {
            return this.advisor.resolveAnnotation((Constructor)member, annotationType) != null;
        }
        if (member instanceof Field) {
            return this.advisor.resolveAnnotation((Field)member, annotationType) != null;
        }
        if (member instanceof Method) {
            return this.advisor.hasAnnotation((Method)member, annotationType);
        }
        throw new IllegalStateException("unknown type of member " + member);
    }

    @Override
    public <A extends Annotation> A resolveAnnotation(Class<?> cls, Class<A> annotationType) {
        return (A)((Annotation)annotationType.cast(this.advisor.resolveAnnotation(annotationType)));
    }

    @Override
    public <A extends Annotation> A resolveAnnotation(Class<?> cls, Member member, Class<A> annotationType) {
        this.checkClass(cls);
        if (member instanceof Constructor) {
            return (A)((Annotation)annotationType.cast(this.advisor.resolveAnnotation((Constructor)member, annotationType)));
        }
        if (member instanceof Field) {
            return (A)((Annotation)annotationType.cast(this.advisor.resolveAnnotation((Field)member, annotationType)));
        }
        if (member instanceof Method) {
            return (A)((Annotation)annotationType.cast(this.advisor.resolveAnnotation((Method)member, annotationType)));
        }
        throw new IllegalStateException("unknown type of member " + member);
    }
}

