/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.container;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.Domain;
import org.jboss.aop.DomainDefinition;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.annotation.AnnotationRepository;
import org.jboss.aop.util.MethodHashing;
import org.jboss.ejb3.interceptors.InterceptorFactoryRef;
import org.jboss.ejb3.interceptors.annotation.AnnotationAdvisor;
import org.jboss.ejb3.interceptors.annotation.AnnotationAdvisorSupport;
import org.jboss.ejb3.interceptors.aop.LifecycleCallbacks;
import org.jboss.ejb3.interceptors.container.BeanContext;
import org.jboss.ejb3.interceptors.container.BeanContextFactory;
import org.jboss.ejb3.interceptors.container.ContainerInterceptorFactory;
import org.jboss.ejb3.interceptors.container.ContainerMethodInvocation;
import org.jboss.ejb3.interceptors.container.InterceptorFactoryRefImpl;
import org.jboss.ejb3.interceptors.container.LifecycleMethodInterceptorsInvocation;
import org.jboss.ejb3.interceptors.container.ManagedObjectAdvisor;
import org.jboss.ejb3.interceptors.container.SimpleBeanContextFactory;
import org.jboss.ejb3.interceptors.lang.ClassHelper;
import org.jboss.ejb3.interceptors.registry.InterceptorRegistry;
import org.jboss.logging.Logger;

public abstract class AbstractContainer<T, C extends AbstractContainer<T, C>>
extends AnnotationAdvisorSupport
implements AnnotationAdvisor {
    private static final Logger log = Logger.getLogger(AbstractContainer.class);
    private ManagedObjectAdvisor<T, C> advisor;
    private InterceptorRegistry interceptorRegistry;
    private Class<? extends BeanContextFactory> beanContextFactoryClass = SimpleBeanContextFactory.class;
    private BeanContextFactory<T, C> beanContextFactory;
    protected Map<Class<? extends Annotation>, Interceptor[]> lifecycleCallbackInterceptors = new HashMap<Class<? extends Annotation>, Interceptor[]>();

    protected AbstractContainer() {
    }

    protected AbstractContainer(String name, Domain domain, Class<? extends T> beanClass) {
        this.initializeAdvisor(name, domain, beanClass);
    }

    protected AbstractContainer(String name, String domainName, Class<? extends T> beanClass) {
        this(name, AbstractContainer.getDomain(domainName), beanClass);
    }

    protected BeanContext<T> construct(Constructor<? extends T> constructor, Object ... initargs) {
        int idx = this.advisor.getConstructorIndex(constructor);
        assert (idx != -1) : "can't find constructor in the advisor";
        try {
            return this.getBeanContextFactory().createBean();
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    protected Object createInterceptor(Class<?> interceptorClass) throws InstantiationException, IllegalAccessException {
        return interceptorClass.newInstance();
    }

    protected void destroy(BeanContext<T> bean) {
        this.getBeanContextFactory().destroyBean(bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BeanContextFactory<T, C> getBeanContextFactory() {
        if (this.beanContextFactory == null) {
            AbstractContainer abstractContainer = this;
            synchronized (abstractContainer) {
                if (this.beanContextFactory == null) {
                    if (this.beanContextFactoryClass == null) {
                        throw new IllegalStateException("beanContextFactoryClass has not been set");
                    }
                    try {
                        this.beanContextFactory = this.beanContextFactoryClass.newInstance();
                        this.beanContextFactory.setContainer(this);
                    }
                    catch (InstantiationException e) {
                        throw new RuntimeException(e.getCause());
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.beanContextFactory;
    }

    protected void initializeAdvisor(String name, Domain domain, Class<? extends T> beanClass) {
        this.initializeAdvisor(name, domain, beanClass, null);
    }

    protected final void initializeAdvisor(String name, Domain domain, Class<? extends T> beanClass, AnnotationRepository annotations) {
        if (this.advisor != null) {
            throw new IllegalStateException("advisor already set to " + this.advisor);
        }
        assert (name != null) : "name is null";
        assert (domain != null) : "domain is null";
        assert (beanClass != null) : "beanClass is null";
        this.createAndSetAdvisor(name, domain, beanClass, annotations);
        this.advisor.getAnnotations().addClassAnnotation(InterceptorFactoryRef.class, (Object)new InterceptorFactoryRefImpl(ContainerInterceptorFactory.class));
        this.advisor.initialize(beanClass);
    }

    protected final void createAndSetAdvisor(String name, Domain domain, Class<? extends T> beanClass, AnnotationRepository annotations) {
        this.advisor = this.createAdvisor(name, domain, beanClass, annotations);
    }

    protected ManagedObjectAdvisor<T, C> createAdvisor(String name, Domain domain, Class<? extends T> beanClass, AnnotationRepository annotations) {
        return new ManagedObjectAdvisor(this, name, (AspectManager)domain, annotations);
    }

    protected final ManagedObjectAdvisor<T, C> getAdvisor() {
        if (this.advisor == null) {
            throw new IllegalStateException("advisor has not been initialized");
        }
        return this.advisor;
    }

    protected Class<? extends T> getBeanClass() {
        return this.getAdvisor().getClazz();
    }

    public static <C extends AbstractContainer<?, ?>> C getContainer(Advisor advisor) {
        return ((ManagedObjectAdvisor)advisor).getContainer();
    }

    protected static final Domain getDomain(String domainName) {
        DomainDefinition domainDefinition = AspectManager.instance().getContainer(domainName);
        if (domainDefinition == null) {
            throw new IllegalArgumentException("Domain definition '" + domainName + "' can not be found");
        }
        Domain domain = (Domain)domainDefinition.getManager();
        return domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterceptorRegistry getInterceptorRegistry() {
        if (this.interceptorRegistry == null) {
            AbstractContainer abstractContainer = this;
            synchronized (abstractContainer) {
                if (this.interceptorRegistry == null) {
                    this.interceptorRegistry = new InterceptorRegistry((Advisor)this.getAdvisor());
                }
            }
        }
        return this.interceptorRegistry;
    }

    public void invokeCallback(BeanContext<?> beanContext, Class<? extends Annotation> callbackAnnotationClass) {
        try {
            Interceptor[] interceptors = this.getLifecycleInterceptors(callbackAnnotationClass);
            LifecycleMethodInterceptorsInvocation invocation = new LifecycleMethodInterceptorsInvocation(beanContext, interceptors);
            invocation.setAdvisor((Advisor)this.getAdvisor());
            invocation.invokeNext();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected Interceptor[] getLifecycleInterceptors(Class<? extends Annotation> lifecycleCallbackAnnotation) {
        Interceptor[] interceptors = this.lifecycleCallbackInterceptors.get(lifecycleCallbackAnnotation);
        if (interceptors == null) {
            List<Class<?>> lifecycleInterceptorClasses = this.getInterceptorRegistry().getLifecycleInterceptorClasses();
            interceptors = LifecycleCallbacks.createLifecycleCallbackInterceptors(this.getAdvisor(), lifecycleInterceptorClasses, lifecycleCallbackAnnotation);
            if (interceptors == null) {
                interceptors = new Interceptor[]{};
            }
            this.lifecycleCallbackInterceptors.put(lifecycleCallbackAnnotation, interceptors);
        }
        return this.lifecycleCallbackInterceptors.get(lifecycleCallbackAnnotation);
    }

    protected Object invoke(BeanContext<T> target, Method method, Object[] arguments) throws Throwable {
        long methodHash = MethodHashing.calculateHash((Method)method);
        MethodInfo info = this.getAdvisor().getMethodInfo(methodHash);
        if (info == null) {
            throw new IllegalArgumentException("method " + method + " is not under advisement by " + this);
        }
        ContainerMethodInvocation invocation = new ContainerMethodInvocation(info, target, arguments);
        return invocation.invokeNext();
    }

    protected <R> R invoke(BeanContext<T> target, String methodName, Object ... args) throws Throwable {
        Method method = ClassHelper.getMethod(target.getInstance().getClass(), methodName);
        return (R)this.invoke(target, method, args);
    }

    public void setBeanContextFactoryClass(Class<? extends BeanContextFactory<T, C>> beanContextFactoryClass) {
        this.beanContextFactoryClass = beanContextFactoryClass;
    }
}

