/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.jsf.integration.config;

import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.jboss.logging.Logger;
import org.jboss.web.validation.ValidatorFactoryVDFConnector;

public class JBossJSFInitializer {
    private static Logger LOG = Logger.getLogger(JBossJSFInitializer.class);
    private ServletContext servletContext;

    public JBossJSFInitializer(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void addBeanValidatorFactory() {
        ValidatorFactory factory;
        ValidatorFactoryVDFConnector vfc = new ValidatorFactoryVDFConnector(this.servletContext);
        if (vfc.isValid()) {
            factory = (ValidatorFactory)vfc.getUtility();
        } else {
            LOG.warn((Object)"No such ValidatorFactory in VDF layer, creating new instance.");
            factory = Validation.buildDefaultValidatorFactory();
        }
        this.servletContext.setAttribute("javax.faces.validator.beanValidator.ValidatorFactory", (Object)factory);
    }

    public Boolean addFacesMappings() {
        if (this.hasJSFServlet()) {
            return Boolean.FALSE;
        }
        ServletRegistration.Dynamic facesServlet = this.servletContext.addServlet("FacesServlet", "javax.faces.webapp.FacesServlet");
        facesServlet.addMapping(new String[]{"/faces/*", "*.jsf", "*.faces"});
        return Boolean.TRUE;
    }

    private boolean hasJSFServlet() {
        Map servletRegistrations = this.servletContext.getServletRegistrations();
        for (ServletRegistration registration : servletRegistrations.values()) {
            if (!"javax.faces.webapp.FacesServlet".equals(registration.getClassName())) continue;
            return true;
        }
        return false;
    }

    public static void initializeJspRuntime() {
        try {
            Class.forName("org.apache.jasper.compiler.JspRuntimeContext");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

