/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.hibernate;

import java.net.URL;
import org.jboss.classloader.plugins.ClassLoaderUtils;
import org.jboss.classloading.spi.visitor.ClassFilter;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.scanning.hibernate.ScannerImpl;

public class PackageVisitor
implements ResourceVisitor {
    private final ScannerImpl scanner;

    public PackageVisitor(ScannerImpl scanner) {
        if (scanner == null) {
            throw new IllegalArgumentException("Null scanner");
        }
        this.scanner = scanner;
    }

    public ResourceFilter getFilter() {
        return ClassFilter.INSTANCE;
    }

    public void visit(ResourceContext resource) {
        URL ownerURL = this.scanner.getOwnerURL(resource);
        String className = resource.getClassName();
        String pckg = ClassLoaderUtils.getClassPackageName((String)className);
        this.scanner.addPackage(ownerURL, pckg);
    }
}

