/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.classloading;

import org.jboss.classloading.spi.dependency.ClassLoading;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.dependency.policy.ClassLoaderPolicyModule;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractOptionalRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassLoaderDescribeDeployer
extends AbstractOptionalRealDeployer<ClassLoadingMetaData> {
    private ClassLoading classLoading;

    public AbstractClassLoaderDescribeDeployer() {
        super(ClassLoadingMetaData.class);
        this.setStage(DeploymentStages.DESCRIBE);
        this.addInput(Module.class);
        this.addOutput(Module.class);
    }

    public ClassLoading getClassLoading() {
        return this.classLoading;
    }

    public void setClassLoading(ClassLoading classLoading) {
        this.classLoading = classLoading;
    }

    public void create() throws Exception {
        if (this.classLoading == null) {
            throw new DeploymentException("Classloading has not been configured");
        }
    }

    public void deploy(DeploymentUnit unit, ClassLoadingMetaData deployment) throws DeploymentException {
        ClassLoaderPolicyModule module = (ClassLoaderPolicyModule)unit.getAttachment(Module.class.getName(), ClassLoaderPolicyModule.class);
        if (module != null) {
            return;
        }
        if (!unit.isTopLevel()) {
            if (deployment == null) {
                return;
            }
            String unitName = unit.getName();
            if (!deployment.isTopLevelClassLoader()) {
                if (deployment.getParentDomain() == null) {
                    deployment.setDomain(unitName);
                    this.log.debugf("Will use synthetic domain for classloader of subdeployment: %1s", (Object)unitName);
                } else {
                    this.log.debugf("Will create top level classloader for subdeployment: %1s", (Object)unitName);
                }
            } else {
                this.log.debugf("Asked to create top level classloader for subdeployment: %1s", (Object)unitName);
            }
        }
        if ((module = this.createModule(unit, deployment)) != null) {
            this.classLoading.addModule((Module)module);
            unit.addAttachment(Module.class, (Object)module);
        }
    }

    public void undeploy(DeploymentUnit unit, ClassLoadingMetaData deployment) {
        Module module = (Module)unit.removeAttachment(Module.class);
        if (module != null && this.classLoading != null) {
            this.classLoading.removeModule(module);
        }
    }

    protected abstract ClassLoaderPolicyModule createModule(DeploymentUnit var1, ClassLoadingMetaData var2) throws DeploymentException;
}

