/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.classloading;

import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloading.spi.dependency.ClassLoading;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.dependency.policy.ClassLoaderPolicyModule;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.deployers.spi.deployer.helpers.AbstractClassLoaderDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;

public class AbstractLevelClassLoaderSystemDeployer
extends AbstractClassLoaderDeployer {
    private ClassLoading classLoading;
    private ClassLoaderSystem system;

    public ClassLoading getClassLoading() {
        return this.classLoading;
    }

    public void setClassLoading(ClassLoading classLoading) {
        this.classLoading = classLoading;
    }

    public ClassLoaderSystem getSystem() {
        return this.system;
    }

    public void setSystem(ClassLoaderSystem system) {
        this.system = system;
    }

    public void create() {
        if (this.classLoading == null) {
            throw new IllegalStateException("The classLoading has not been set");
        }
        if (this.system == null) {
            throw new IllegalStateException("The system has not been set");
        }
    }

    public ClassLoader createClassLoader(DeploymentUnit unit) throws Exception {
        if (this.classLoading == null) {
            throw new IllegalStateException("The classLoading has not been set");
        }
        if (this.system == null) {
            throw new IllegalStateException("The system has not been set");
        }
        Module module = (Module)unit.getAttachment(Module.class);
        if (module == null) {
            if (this.isTopLevelOnly()) {
                throw new IllegalStateException("No module for top level deployment " + unit.getName());
            }
            return unit.getParent().getClassLoader();
        }
        if (!(module instanceof ClassLoaderPolicyModule)) {
            throw new IllegalStateException("Module is not an instance of " + ClassLoaderPolicyModule.class.getName() + " actual=" + module.getClass().getName());
        }
        ClassLoaderPolicyModule classLoaderPolicyModule = (ClassLoaderPolicyModule)module;
        boolean explicitTopLevel = false;
        ClassLoadingMetaData clmd = (ClassLoadingMetaData)unit.getAttachment(ClassLoadingMetaData.class);
        if (clmd != null && clmd.isTopLevelClassLoader()) {
            explicitTopLevel = true;
        }
        if (unit.isTopLevel() || module.getParentDomainName() != null || explicitTopLevel) {
            return classLoaderPolicyModule.registerClassLoaderPolicy(this.system);
        }
        ClassLoader parentClassLoader = unit.getParent().getClassLoader();
        return classLoaderPolicyModule.registerClassLoaderPolicy(this.system, parentClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClassLoader(DeploymentUnit unit) throws Exception {
        Module module = (Module)unit.getAttachment(Module.class);
        if (module == null) {
            return;
        }
        ClassLoader classLoader = unit.getClassLoader();
        try {
            try {
                this.system.unregisterClassLoader(classLoader);
            }
            finally {
                ClassLoaderDomain domain;
                String domainName = module.getDeterminedDomainName();
                if (!"DefaultDomain".equals(domainName) && !(domain = this.system.getDomain(domainName)).hasClassLoaders()) {
                    this.system.unregisterDomain(domain);
                }
            }
        }
        finally {
            this.cleanup(unit, module);
            module.reset();
        }
    }

    protected void cleanup(DeploymentUnit unit, Module module) throws Exception {
    }
}

